/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.sql.tree.Table;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableWriterNode
extends PlanNode {
    private final PlanNode source;
    private final WriterTarget target;
    private final Symbol rowCountSymbol;
    private final Symbol fragmentSymbol;
    private final List<Symbol> columns;
    private final List<String> columnNames;
    private final Set<Symbol> notNullColumnSymbols;
    private final Optional<PartitioningScheme> partitioningScheme;
    private final Optional<PartitioningScheme> preferredPartitioningScheme;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor;
    private final List<Symbol> outputs;

    @JsonCreator
    public TableWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") WriterTarget target, @JsonProperty(value="rowCountSymbol") Symbol rowCountSymbol, @JsonProperty(value="fragmentSymbol") Symbol fragmentSymbol, @JsonProperty(value="columns") List<Symbol> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="notNullColumnSymbols") Set<Symbol> notNullColumnSymbols, @JsonProperty(value="partitioningScheme") Optional<PartitioningScheme> partitioningScheme, @JsonProperty(value="preferredPartitioningScheme") Optional<PartitioningScheme> preferredPartitioningScheme, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation, @JsonProperty(value="statisticsAggregationDescriptor") Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor) {
        super(id);
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((columns.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columns and columnNames sizes don't match");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountSymbol = Objects.requireNonNull(rowCountSymbol, "rowCountSymbol is null");
        this.fragmentSymbol = Objects.requireNonNull(fragmentSymbol, "fragmentSymbol is null");
        this.columns = ImmutableList.copyOf(columns);
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.notNullColumnSymbols = ImmutableSet.copyOf((Collection)Objects.requireNonNull(notNullColumnSymbols, "notNullColumnSymbols is null"));
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        this.preferredPartitioningScheme = Objects.requireNonNull(preferredPartitioningScheme, "preferredPartitioningScheme is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        this.statisticsAggregationDescriptor = Objects.requireNonNull(statisticsAggregationDescriptor, "statisticsAggregationDescriptor is null");
        Preconditions.checkArgument((statisticsAggregation.isPresent() == statisticsAggregationDescriptor.isPresent() ? 1 : 0) != 0, (Object)"statisticsAggregation and statisticsAggregationDescriptor must be either present or absent");
        Preconditions.checkArgument((partitioningScheme.isEmpty() || preferredPartitioningScheme.isEmpty() ? 1 : 0) != 0, (Object)"Both partitioningScheme and preferredPartitioningScheme cannot be present");
        ImmutableList.Builder outputs = ImmutableList.builder().add((Object)rowCountSymbol).add((Object)fragmentSymbol);
        statisticsAggregation.ifPresent(aggregation -> {
            outputs.addAll(aggregation.getGroupingSymbols());
            outputs.addAll(aggregation.getAggregations().keySet());
        });
        this.outputs = outputs.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WriterTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getRowCountSymbol() {
        return this.rowCountSymbol;
    }

    @JsonProperty
    public Symbol getFragmentSymbol() {
        return this.fragmentSymbol;
    }

    @JsonProperty
    public List<Symbol> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public Set<Symbol> getNotNullColumnSymbols() {
        return this.notNullColumnSymbols;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPreferredPartitioningScheme() {
        return this.preferredPartitioningScheme;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    @JsonProperty
    public Optional<StatisticAggregationsDescriptor<Symbol>> getStatisticsAggregationDescriptor() {
        return this.statisticsAggregationDescriptor;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableWriter(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TableWriterNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountSymbol, this.fragmentSymbol, this.columns, this.columnNames, this.notNullColumnSymbols, this.partitioningScheme, this.preferredPartitioningScheme, this.statisticsAggregation, this.statisticsAggregationDescriptor);
    }

    public static class TableExecuteTarget
    extends WriterTarget {
        private final TableExecuteHandle executeHandle;
        private final Optional<TableHandle> sourceHandle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public TableExecuteTarget(@JsonProperty(value="executeHandle") TableExecuteHandle executeHandle, @JsonProperty(value="sourceHandle") Optional<TableHandle> sourceHandle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.executeHandle = Objects.requireNonNull(executeHandle, "handle is null");
            this.sourceHandle = Objects.requireNonNull(sourceHandle, "sourceHandle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public TableExecuteHandle getExecuteHandle() {
            return this.executeHandle;
        }

        @JsonProperty
        public Optional<TableHandle> getSourceHandle() {
            return this.sourceHandle;
        }

        public TableHandle getMandatorySourceHandle() {
            return this.sourceHandle.orElseThrow();
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.executeHandle.toString();
        }
    }

    public static class UpdateTarget
    extends WriterTarget {
        private final Optional<TableHandle> handle;
        private final SchemaTableName schemaTableName;
        private final List<String> updatedColumns;
        private final List<ColumnHandle> updatedColumnHandles;

        @JsonCreator
        public UpdateTarget(@JsonProperty(value="handle") Optional<TableHandle> handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="updatedColumns") List<String> updatedColumns, @JsonProperty(value="updatedColumnHandles") List<ColumnHandle> updatedColumnHandles) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            Preconditions.checkArgument((updatedColumns.size() == updatedColumnHandles.size() ? 1 : 0) != 0, (String)"updatedColumns size %s must equal updatedColumnHandles size %s", (int)updatedColumns.size(), (int)updatedColumnHandles.size());
            this.updatedColumns = Objects.requireNonNull(updatedColumns, "updatedColumns is null");
            this.updatedColumnHandles = Objects.requireNonNull(updatedColumnHandles, "updatedColumnHandles is null");
        }

        @JsonProperty
        public Optional<TableHandle> getHandle() {
            return this.handle;
        }

        @JsonIgnore
        public TableHandle getHandleOrElseThrow() {
            return this.handle.orElseThrow(() -> new IllegalStateException("UpdateTarge does not contain handle"));
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public List<String> getUpdatedColumns() {
            return this.updatedColumns;
        }

        @JsonProperty
        public List<ColumnHandle> getUpdatedColumnHandles() {
            return this.updatedColumnHandles;
        }

        @Override
        public String toString() {
            return this.handle.map(Object::toString).orElse("[]");
        }
    }

    public static class DeleteTarget
    extends WriterTarget {
        private final Optional<TableHandle> handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public DeleteTarget(@JsonProperty(value="handle") Optional<TableHandle> handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public Optional<TableHandle> getHandle() {
            return this.handle;
        }

        @JsonIgnore
        public TableHandle getHandleOrElseThrow() {
            return this.handle.orElseThrow(() -> new IllegalStateException("DeleteTarget does not contain handle"));
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.map(Object::toString).orElse("[]");
        }
    }

    public static class RefreshMaterializedViewTarget
    extends WriterTarget {
        private final TableHandle tableHandle;
        private final InsertTableHandle insertHandle;
        private final SchemaTableName schemaTableName;
        private final List<TableHandle> sourceTableHandles;

        @JsonCreator
        public RefreshMaterializedViewTarget(@JsonProperty(value="tableHandle") TableHandle tableHandle, @JsonProperty(value="insertHandle") InsertTableHandle insertHandle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="sourceTableHandles") List<TableHandle> sourceTableHandles) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
            this.insertHandle = Objects.requireNonNull(insertHandle, "insertHandle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.sourceTableHandles = ImmutableList.copyOf(sourceTableHandles);
        }

        @JsonProperty
        public TableHandle getTableHandle() {
            return this.tableHandle;
        }

        @JsonProperty
        public InsertTableHandle getInsertHandle() {
            return this.insertHandle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public List<TableHandle> getSourceTableHandles() {
            return this.sourceTableHandles;
        }

        @Override
        public String toString() {
            return this.insertHandle.toString();
        }
    }

    public static class RefreshMaterializedViewReference
    extends WriterTarget {
        private final Table table;
        private final TableHandle storageTableHandle;
        private final List<TableHandle> sourceTableHandles;

        public RefreshMaterializedViewReference(Table table, TableHandle storageTableHandle, List<TableHandle> sourceTableHandles) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.storageTableHandle = Objects.requireNonNull(storageTableHandle, "storageTableHandle is null");
            this.sourceTableHandles = ImmutableList.copyOf(sourceTableHandles);
        }

        public Table getTable() {
            return this.table;
        }

        public TableHandle getStorageTableHandle() {
            return this.storageTableHandle;
        }

        public List<TableHandle> getSourceTableHandles() {
            return this.sourceTableHandles;
        }

        @Override
        public String toString() {
            return this.table.toString();
        }
    }

    public static class InsertTarget
    extends WriterTarget {
        private final InsertTableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public InsertTarget(@JsonProperty(value="handle") InsertTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public InsertTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertReference
    extends WriterTarget {
        private final TableHandle handle;
        private final List<ColumnHandle> columns;

        public InsertReference(TableHandle handle, List<ColumnHandle> columns) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateTarget
    extends WriterTarget {
        private final OutputTableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public CreateTarget(@JsonProperty(value="handle") OutputTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public OutputTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateReference
    extends WriterTarget {
        private final String catalog;
        private final ConnectorTableMetadata tableMetadata;
        private final Optional<TableLayout> layout;

        public CreateReference(String catalog, ConnectorTableMetadata tableMetadata, Optional<TableLayout> layout) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
        }

        public String getCatalog() {
            return this.catalog;
        }

        public ConnectorTableMetadata getTableMetadata() {
            return this.tableMetadata;
        }

        public Optional<TableLayout> getLayout() {
            return this.layout;
        }

        @Override
        public String toString() {
            return this.catalog + "." + this.tableMetadata.getTable();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CreateTarget.class, name="CreateTarget"), @JsonSubTypes.Type(value=InsertTarget.class, name="InsertTarget"), @JsonSubTypes.Type(value=DeleteTarget.class, name="DeleteTarget"), @JsonSubTypes.Type(value=UpdateTarget.class, name="UpdateTarget"), @JsonSubTypes.Type(value=RefreshMaterializedViewTarget.class, name="RefreshMaterializedViewTarget"), @JsonSubTypes.Type(value=TableExecuteTarget.class, name="TableExecuteTarget")})
    public static abstract class WriterTarget {
        public abstract String toString();
    }
}

