/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RenameView;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class RenameViewTask
implements DataDefinitionTask<RenameView> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public RenameViewTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "RENAME VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(RenameView statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedObjectName viewName;
        Session session = stateMachine.getSession();
        if (this.metadata.isMaterializedView(session, viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource()))) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist, but a materialized view with that name exists. Did you mean ALTER MATERIALIZED VIEW %s RENAME TO ...?", viewName, viewName);
        }
        if (!this.metadata.isView(session, viewName)) {
            if (this.metadata.getTableHandle(session, viewName).isPresent()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist, but a table with that name exists. Did you mean ALTER TABLE %s RENAME TO ...?", viewName, viewName);
            }
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", viewName);
        }
        QualifiedObjectName target = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTarget());
        if (this.metadata.getCatalogHandle(session, target.getCatalogName()).isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (this.metadata.isView(session, target)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target view '%s' already exists", target);
        }
        if (!viewName.getCatalogName().equals(target.getCatalogName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "View rename across catalogs is not supported", new Object[0]);
        }
        this.accessControl.checkCanRenameView(session.toSecurityContext(), viewName, target);
        this.metadata.renameView(session, viewName, target);
        return Futures.immediateVoidFuture();
    }
}

