/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.collect.AbstractIterator;
import com.google.common.io.ByteStreams;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.trino.block.BlockSerdeUtil;
import io.trino.execution.buffer.PagesSerde;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class PagesSerdeUtil {
    public static final long NO_CHECKSUM = 81985529216486895L;

    private PagesSerdeUtil() {
    }

    static void writeRawPage(Page page, SliceOutput output, BlockEncodingSerde serde) {
        output.writeInt(page.getChannelCount());
        for (int channel = 0; channel < page.getChannelCount(); ++channel) {
            BlockSerdeUtil.writeBlock(serde, output, page.getBlock(channel));
        }
    }

    static Page readRawPage(int positionCount, SliceInput input, BlockEncodingSerde blockEncodingSerde) {
        int numberOfBlocks = input.readInt();
        Block[] blocks = new Block[numberOfBlocks];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockSerdeUtil.readBlock(blockEncodingSerde, input);
        }
        return new Page(positionCount, blocks);
    }

    public static long calculateChecksum(List<Slice> pages) {
        XxHash64 hash = new XxHash64();
        for (Slice page : pages) {
            hash.update(page);
        }
        long checksum = hash.hash();
        if (checksum == 81985529216486895L) {
            return checksum + 1L;
        }
        return checksum;
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Page ... pages) {
        return PagesSerdeUtil.writePages(serde, sliceOutput, Arrays.asList(pages).iterator());
    }

    public static long writePages(PagesSerde serde, SliceOutput sliceOutput, Iterator<Page> pages) {
        long size = 0L;
        try (PagesSerde.PagesSerdeContext context = serde.newContext();){
            while (pages.hasNext()) {
                Page page = pages.next();
                sliceOutput.writeBytes(serde.serialize(context, page));
                size += page.getSizeInBytes();
            }
        }
        return size;
    }

    public static Iterator<Page> readPages(PagesSerde serde, InputStream inputStream) {
        return new PageReader(serde, inputStream);
    }

    public static Iterator<Slice> readSerializedPages(InputStream inputStream) {
        return new SerializedPageReader(inputStream);
    }

    private static class SerializedPageReader
    extends AbstractIterator<Slice> {
        private final InputStream inputStream;
        private final byte[] headerBuffer = new byte[13];
        private final Slice headerSlice = Slices.wrappedBuffer((byte[])this.headerBuffer);

        SerializedPageReader(InputStream input) {
            this.inputStream = Objects.requireNonNull(input, "inputStream is null");
        }

        protected Slice computeNext() {
            try {
                int read = ByteStreams.read((InputStream)this.inputStream, (byte[])this.headerBuffer, (int)0, (int)this.headerBuffer.length);
                if (read <= 0) {
                    return (Slice)this.endOfData();
                }
                if (read != this.headerBuffer.length) {
                    throw new EOFException();
                }
                return PagesSerde.readSerializedPage(this.headerSlice, this.inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class PageReader
    extends AbstractIterator<Page> {
        private final PagesSerde serde;
        private final PagesSerde.PagesSerdeContext context;
        private final InputStream inputStream;
        private final byte[] headerBuffer = new byte[13];
        private final Slice headerSlice = Slices.wrappedBuffer((byte[])this.headerBuffer);

        PageReader(PagesSerde serde, InputStream inputStream) {
            this.serde = Objects.requireNonNull(serde, "serde is null");
            this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
            this.context = serde.newContext();
        }

        protected Page computeNext() {
            try {
                int read = ByteStreams.read((InputStream)this.inputStream, (byte[])this.headerBuffer, (int)0, (int)this.headerBuffer.length);
                if (read <= 0) {
                    this.context.close();
                    return (Page)this.endOfData();
                }
                if (read != this.headerBuffer.length) {
                    throw new EOFException();
                }
                return this.serde.deserialize(this.context, PagesSerde.readSerializedPage(this.headerSlice, this.inputStream));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

