/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.airlift.log.Logger;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeStat;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.operator.TaskStats;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.util.Failures;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class TaskExecutionStats {
    private static final Logger log = Logger.get(TaskExecutionStats.class);
    private final ExecutionStats finishedTasks = new ExecutionStats();
    private final ExecutionStats abortedTasks = new ExecutionStats();
    private final FailedTasksStats failedTasks = new FailedTasksStats();

    public void update(TaskInfo info) {
        TaskState state = info.getTaskStatus().getState();
        switch (state) {
            case FINISHED: {
                this.finishedTasks.update(info.getStats());
                break;
            }
            case FAILED: {
                this.failedTasks.update(info);
                break;
            }
            case CANCELED: 
            case ABORTED: {
                this.abortedTasks.update(info.getStats());
                break;
            }
            default: {
                log.error("Unexpected task state: %s", new Object[]{state});
            }
        }
    }

    @Managed
    @Nested
    public ExecutionStats getFinishedTasks() {
        return this.finishedTasks;
    }

    @Managed
    @Nested
    public ExecutionStats getAbortedTasks() {
        return this.abortedTasks;
    }

    @Managed
    @Nested
    public FailedTasksStats getFailedTasks() {
        return this.failedTasks;
    }

    public static class FailedTasksStats {
        private final ExecutionStats userError = new ExecutionStats();
        private final ExecutionStats internalError = new ExecutionStats();
        private final ExecutionStats externalError = new ExecutionStats();
        private final ExecutionStats insufficientResources = new ExecutionStats();

        public void update(TaskInfo info) {
            ExecutionFailureInfo failureInfo = info.getTaskStatus().getFailures().stream().findFirst().orElse(Failures.toFailure(new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "A task failed for an unknown reason")));
            ErrorType errorType = Optional.ofNullable(failureInfo.getErrorCode()).map(ErrorCode::getType).orElse(ErrorType.INTERNAL_ERROR);
            TaskStats stats = info.getStats();
            switch (errorType) {
                case USER_ERROR: {
                    this.userError.update(stats);
                    break;
                }
                case INTERNAL_ERROR: {
                    this.internalError.update(stats);
                    break;
                }
                case EXTERNAL: {
                    this.externalError.update(stats);
                    break;
                }
                case INSUFFICIENT_RESOURCES: {
                    this.insufficientResources.update(stats);
                    break;
                }
                default: {
                    log.error("Unexpected error type: %s", new Object[]{errorType});
                }
            }
        }

        @Managed
        @Nested
        public ExecutionStats getUserError() {
            return this.userError;
        }

        @Managed
        @Nested
        public ExecutionStats getInternalError() {
            return this.internalError;
        }

        @Managed
        @Nested
        public ExecutionStats getExternalError() {
            return this.externalError;
        }

        @Managed
        @Nested
        public ExecutionStats getInsufficientResources() {
            return this.insufficientResources;
        }
    }

    public static class ExecutionStats {
        private final TimeStat elapsedTime = new TimeStat(TimeUnit.MILLISECONDS);
        private final TimeStat scheduledTime = new TimeStat(TimeUnit.MILLISECONDS);
        private final TimeStat cpuTime = new TimeStat(TimeUnit.MILLISECONDS);
        private final TimeStat inputBlockedTime = new TimeStat(TimeUnit.MILLISECONDS);
        private final TimeStat outputBlockedTime = new TimeStat(TimeUnit.MILLISECONDS);
        private final DistributionStat peakMemoryReservationInBytes = new DistributionStat();

        public void update(TaskStats stats) {
            this.elapsedTime.add(stats.getElapsedTime());
            this.scheduledTime.add(stats.getTotalScheduledTime());
            this.cpuTime.add(stats.getTotalCpuTime());
            this.inputBlockedTime.add(stats.getInputBlockedTime());
            this.outputBlockedTime.add(stats.getOutputBlockedTime());
            this.peakMemoryReservationInBytes.add(stats.getPeakUserMemoryReservation().toBytes());
        }

        @Managed
        @Nested
        public TimeStat getElapsedTime() {
            return this.elapsedTime;
        }

        @Managed
        @Nested
        public TimeStat getScheduledTime() {
            return this.scheduledTime;
        }

        @Managed
        @Nested
        public TimeStat getCpuTime() {
            return this.cpuTime;
        }

        @Managed
        @Nested
        public TimeStat getInputBlockedTime() {
            return this.inputBlockedTime;
        }

        @Managed
        @Nested
        public TimeStat getOutputBlockedTime() {
            return this.outputBlockedTime;
        }

        @Managed
        @Nested
        public DistributionStat getPeakMemoryReservationInBytes() {
            return this.peakMemoryReservationInBytes;
        }
    }
}

