/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.Objects;
import java.util.Optional;

public class IrArithmeticUnary
extends IrPathNode {
    private final Sign sign;
    private final IrPathNode base;

    @JsonCreator
    public IrArithmeticUnary(@JsonProperty(value="sign") Sign sign, @JsonProperty(value="base") IrPathNode base, @JsonProperty(value="type") Optional<Type> type) {
        super(type);
        this.sign = Objects.requireNonNull(sign, "sign is null");
        this.base = Objects.requireNonNull(base, "base is null");
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrArithmeticUnary(this, context);
    }

    @JsonProperty
    public Sign getSign() {
        return this.sign;
    }

    @JsonProperty
    public IrPathNode getBase() {
        return this.base;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrArithmeticUnary other = (IrArithmeticUnary)obj;
        return this.sign == other.sign && Objects.equals(this.base, other.base);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sign, this.base});
    }

    public static enum Sign {
        PLUS("+"),
        MINUS("-");

        private final String sign;

        private Sign(String sign) {
            this.sign = Objects.requireNonNull(sign, "sign is null");
        }

        public String getSign() {
            return this.sign;
        }
    }
}

