/*
 * Decompiled with CFR 0.152.
 */
package io.trino.json.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.trino.json.ir.IrJsonPathVisitor;
import io.trino.json.ir.IrPathNode;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IrConstantJsonSequence
extends IrPathNode {
    public static final IrConstantJsonSequence EMPTY_SEQUENCE = new IrConstantJsonSequence((List<JsonNode>)ImmutableList.of(), Optional.empty());
    private final List<JsonNode> sequence;

    public static IrConstantJsonSequence singletonSequence(JsonNode jsonNode, Optional<Type> type) {
        return new IrConstantJsonSequence((List<JsonNode>)ImmutableList.of((Object)jsonNode), type);
    }

    @JsonCreator
    public IrConstantJsonSequence(@JsonProperty(value="sequence") List<JsonNode> sequence, @JsonProperty(value="type") Optional<Type> type) {
        super(type);
        this.sequence = ImmutableList.copyOf((Collection)Objects.requireNonNull(sequence, "sequence is null"));
    }

    @Override
    protected <R, C> R accept(IrJsonPathVisitor<R, C> visitor, C context) {
        return visitor.visitIrConstantJsonSequence(this, context);
    }

    @JsonProperty
    public List<JsonNode> getSequence() {
        return this.sequence;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrConstantJsonSequence other = (IrConstantJsonSequence)obj;
        return Objects.equals(this.sequence, other.sequence);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sequence);
    }
}

