/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.operator.RetryPolicy;
import io.trino.operator.TaskStats;
import io.trino.spi.memory.MemoryPoolInfo;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class LeastWastedEffortTaskLowMemoryKiller
implements LowMemoryKiller {
    private static final long MIN_WALL_TIME = Duration.of(30L, ChronoUnit.SECONDS).toMillis();

    @Override
    public Optional<KillTarget> chooseTargetToKill(List<LowMemoryKiller.RunningQueryInfo> runningQueries, List<MemoryInfo> nodes) {
        Set queriesWithTaskRetryPolicy = (Set)runningQueries.stream().filter(query -> query.getRetryPolicy() == RetryPolicy.TASK).map(LowMemoryKiller.RunningQueryInfo::getQueryId).collect(ImmutableSet.toImmutableSet());
        if (queriesWithTaskRetryPolicy.isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet.Builder tasksToKillBuilder = ImmutableSet.builder();
        Map taskInfos = (Map)runningQueries.stream().filter(queryInfo -> queriesWithTaskRetryPolicy.contains(queryInfo.getQueryId())).flatMap(queryInfo -> queryInfo.getTaskInfos().entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPool = node.getPool();
            if (memoryPool == null || memoryPool.getFreeBytes() + memoryPool.getReservedRevocableBytes() > 0L) continue;
            memoryPool.getTaskMemoryReservations().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<TaskId, Long>(TaskId.valueOf((String)entry.getKey()), (Long)entry.getValue())).filter(entry -> queriesWithTaskRetryPolicy.contains(((TaskId)entry.getKey()).getQueryId())).max(Comparator.comparing(entry -> {
                TaskId taskId = (TaskId)entry.getKey();
                Long memoryUsed = (Long)entry.getValue();
                long wallTime = 0L;
                if (taskInfos.containsKey(taskId)) {
                    TaskStats stats = ((TaskInfo)taskInfos.get(taskId)).getStats();
                    wallTime = stats.getTotalScheduledTime().toMillis() + stats.getTotalBlockedTime().toMillis();
                }
                wallTime = Math.max(wallTime, MIN_WALL_TIME);
                return (double)memoryUsed.longValue() / (double)wallTime;
            })).map(AbstractMap.SimpleEntry::getKey).ifPresent(arg_0 -> ((ImmutableSet.Builder)tasksToKillBuilder).add(arg_0));
        }
        ImmutableSet tasksToKill = tasksToKillBuilder.build();
        if (tasksToKill.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(KillTarget.selectedTasks((Set<TaskId>)tasksToKill));
    }
}

