/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class AggregationFunctionMetadata {
    private final boolean orderSensitive;
    private final List<TypeSignature> intermediateTypes;

    private AggregationFunctionMetadata(boolean orderSensitive, List<TypeSignature> intermediateTypes) {
        this.orderSensitive = orderSensitive;
        this.intermediateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(intermediateTypes, "intermediateTypes is null"));
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public boolean isDecomposable() {
        return !this.intermediateTypes.isEmpty();
    }

    public List<TypeSignature> getIntermediateTypes() {
        return this.intermediateTypes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orderSensitive", this.orderSensitive).add("intermediateTypes", this.intermediateTypes).toString();
    }

    public static AggregationFunctionMetadataBuilder builder() {
        return new AggregationFunctionMetadataBuilder();
    }

    public static class AggregationFunctionMetadataBuilder {
        private boolean orderSensitive;
        private final List<TypeSignature> intermediateTypes = new ArrayList<TypeSignature>();

        private AggregationFunctionMetadataBuilder() {
        }

        public AggregationFunctionMetadataBuilder orderSensitive() {
            this.orderSensitive = true;
            return this;
        }

        public AggregationFunctionMetadataBuilder intermediateType(Type type) {
            this.intermediateTypes.add(Objects.requireNonNull(type, "type is null").getTypeSignature());
            return this;
        }

        public AggregationFunctionMetadataBuilder intermediateType(TypeSignature type) {
            this.intermediateTypes.add(Objects.requireNonNull(type, "type is null"));
            return this;
        }

        public AggregationFunctionMetadata build() {
            return new AggregationFunctionMetadata(this.orderSensitive, this.intermediateTypes);
        }
    }
}

