/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class SchemaFunctionName {
    private final String schemaName;
    private final String functionName;

    public SchemaFunctionName(String schemaName, String functionName) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        Preconditions.checkArgument((!schemaName.isEmpty() ? 1 : 0) != 0, (Object)"schemaName is empty");
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        Preconditions.checkArgument((!functionName.isEmpty() ? 1 : 0) != 0, (Object)"functionName is empty");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.functionName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaFunctionName other = (SchemaFunctionName)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.functionName, other.functionName);
    }

    public String toString() {
        return this.schemaName + "." + this.functionName;
    }
}

