/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.SqlFunction;
import io.trino.operator.aggregation.AggregationFromAnnotationsParser;
import io.trino.operator.aggregation.AggregationMetadata;
import java.util.List;
import java.util.Objects;

public abstract class SqlAggregationFunction
implements SqlFunction {
    private final FunctionMetadata functionMetadata;
    private final AggregationFunctionMetadata aggregationFunctionMetadata;

    public static List<SqlAggregationFunction> createFunctionsByAnnotations(Class<?> aggregationDefinition) {
        try {
            return ImmutableList.copyOf(AggregationFromAnnotationsParser.parseFunctionDefinitions(aggregationDefinition));
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Invalid aggregation class " + aggregationDefinition.getSimpleName());
        }
    }

    public SqlAggregationFunction(FunctionMetadata functionMetadata, AggregationFunctionMetadata aggregationFunctionMetadata) {
        this.functionMetadata = Objects.requireNonNull(functionMetadata, "functionMetadata is null");
        this.aggregationFunctionMetadata = Objects.requireNonNull(aggregationFunctionMetadata, "aggregationFunctionMetadata is null");
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public AggregationFunctionMetadata getAggregationMetadata() {
        return this.aggregationFunctionMetadata;
    }

    public AggregationMetadata specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return this.specialize(boundSignature);
    }

    protected AggregationMetadata specialize(BoundSignature boundSignature) {
        throw new UnsupportedOperationException();
    }
}

