/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.CatalogSchemaFunctionName;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.SchemaFunctionName;
import io.trino.metadata.TableFunctionMetadata;
import io.trino.spi.ptf.ArgumentSpecification;
import io.trino.spi.ptf.ConnectorTableFunction;
import io.trino.spi.ptf.TableArgumentSpecification;
import io.trino.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TableFunctionRegistry {
    private final Map<CatalogName, Map<SchemaFunctionName, TableFunctionMetadata>> tableFunctions = new ConcurrentHashMap<CatalogName, Map<SchemaFunctionName, TableFunctionMetadata>>();

    public void addTableFunctions(CatalogName catalogName, Collection<ConnectorTableFunction> functions) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(functions, "functions is null");
        functions.stream().forEach(TableFunctionRegistry::validateTableFunction);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ConnectorTableFunction function : functions) {
            builder.put((Object)new SchemaFunctionName(function.getSchema().toLowerCase(Locale.ENGLISH), function.getName().toLowerCase(Locale.ENGLISH)), (Object)new TableFunctionMetadata(catalogName, function));
        }
        Preconditions.checkState((this.tableFunctions.putIfAbsent(catalogName, (Map<SchemaFunctionName, TableFunctionMetadata>)builder.buildOrThrow()) == null ? 1 : 0) != 0, (Object)("Table functions already registered for catalog: " + catalogName));
    }

    public void removeTableFunctions(CatalogName catalogName) {
        this.tableFunctions.remove(catalogName);
    }

    public TableFunctionMetadata resolve(Session session, QualifiedName qualifiedName) {
        for (CatalogSchemaFunctionName name : FunctionResolver.toPath(session, qualifiedName)) {
            String lowercasedFunctionName;
            String lowercasedSchemaName;
            TableFunctionMetadata function;
            CatalogName catalogName = new CatalogName(name.getCatalogName());
            Map<SchemaFunctionName, TableFunctionMetadata> catalogFunctions = this.tableFunctions.get(catalogName);
            if (catalogFunctions == null || (function = catalogFunctions.get(new SchemaFunctionName(lowercasedSchemaName = name.getSchemaFunctionName().getSchemaName().toLowerCase(Locale.ENGLISH), lowercasedFunctionName = name.getSchemaFunctionName().getFunctionName().toLowerCase(Locale.ENGLISH)))) == null) continue;
            return function;
        }
        return null;
    }

    private static void validateTableFunction(ConnectorTableFunction tableFunction) {
        Objects.requireNonNull(tableFunction, "tableFunction is null");
        Objects.requireNonNull(tableFunction.getName(), "table function name is null");
        Objects.requireNonNull(tableFunction.getSchema(), "table function schema name is null");
        Objects.requireNonNull(tableFunction.getArguments(), "table function arguments is null");
        Objects.requireNonNull(tableFunction.getReturnTypeSpecification(), "table function returnTypeSpecification is null");
        Preconditions.checkArgument((!tableFunction.getName().isEmpty() ? 1 : 0) != 0, (Object)"table function name is empty");
        Preconditions.checkArgument((!tableFunction.getSchema().isEmpty() ? 1 : 0) != 0, (Object)"table function schema name is empty");
        HashSet<String> argumentNames = new HashSet<String>();
        for (ArgumentSpecification specification2 : tableFunction.getArguments()) {
            if (argumentNames.add(specification2.getName())) continue;
            throw new IllegalArgumentException("duplicate argument name: " + specification2.getName());
        }
        long tableArgumentsWithRowSemantics = tableFunction.getArguments().stream().filter(specification -> specification instanceof TableArgumentSpecification).map(TableArgumentSpecification.class::cast).filter(TableArgumentSpecification::isRowSemantics).count();
        Preconditions.checkArgument((tableArgumentsWithRowSemantics <= 1L ? 1 : 0) != 0, (Object)"more than one table argument with row semantics");
    }
}

