/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.connector.CatalogName;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public final class TableHandle {
    private final CatalogName catalogName;
    private final ConnectorTableHandle connectorHandle;
    private final ConnectorTransactionHandle transaction;

    @JsonCreator
    public TableHandle(@JsonProperty(value="catalogName") CatalogName catalogName, @JsonProperty(value="connectorHandle") ConnectorTableHandle connectorHandle, @JsonProperty(value="transaction") ConnectorTransactionHandle transaction) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
    }

    @JsonProperty
    public CatalogName getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public ConnectorTableHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransaction() {
        return this.transaction;
    }

    public TableHandle withConnectorHandle(ConnectorTableHandle connectorHandle) {
        return new TableHandle(this.catalogName, connectorHandle, this.transaction);
    }

    public String toString() {
        return this.catalogName + ":" + this.connectorHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableHandle other = (TableHandle)o;
        return Objects.equals(this.catalogName, other.catalogName) && Objects.equals(this.connectorHandle, other.connectorHandle) && Objects.equals(this.transaction, other.transaction);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.connectorHandle, this.transaction);
    }
}

