/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.stats.QuantileDigest;
import io.trino.operator.aggregation.state.QuantileDigestState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.MoreMath;

@AggregationFunction(value="merge", isOrderSensitive=true)
@Description(value="Merges the input quantile digests into a single quantile digest")
public final class MergeQuantileDigestFunction {
    private static final double COMPARISON_EPSILON = 1.0E-6;

    private MergeQuantileDigestFunction() {
    }

    @InputFunction
    @TypeParameter(value="V")
    public static void input(@TypeParameter(value="V") Type type, @AggregationState QuantileDigestState state, @BlockPosition @SqlType(value="V") Block value, @BlockIndex int index) {
        MergeQuantileDigestFunction.merge(state, new QuantileDigest(type.getSlice(value, index)));
    }

    @CombineFunction
    public static void combine(@AggregationState QuantileDigestState state, @AggregationState QuantileDigestState otherState) {
        MergeQuantileDigestFunction.merge(state, otherState.getQuantileDigest());
    }

    private static void merge(QuantileDigestState state, QuantileDigest input) {
        if (input == null) {
            return;
        }
        QuantileDigest previous = state.getQuantileDigest();
        if (previous == null) {
            state.setQuantileDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            Preconditions.checkArgument((boolean)MoreMath.nearlyEqual(previous.getMaxError(), input.getMaxError(), 1.0E-6), (String)"Cannot merge qdigests with different accuracies (%s vs. %s)", (Object)state.getQuantileDigest().getMaxError(), (Object)input.getMaxError());
            Preconditions.checkArgument((boolean)MoreMath.nearlyEqual(previous.getAlpha(), input.getAlpha(), 1.0E-6), (String)"Cannot merge qdigests with different alpha values (%s vs. %s)", (Object)state.getQuantileDigest().getAlpha(), (Object)input.getAlpha());
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    @OutputFunction(value="qdigest(V)")
    public static void output(@TypeParameter(value="V") Type type, @AggregationState QuantileDigestState state, BlockBuilder out) {
        if (state.getQuantileDigest() == null) {
            out.appendNull();
        } else {
            type.writeSlice(out, state.getQuantileDigest().serialize());
        }
    }
}

