/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.operator.ParametricFunctionHelpers;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.aggregation.AggregationFromAnnotationsParser;
import io.trino.operator.aggregation.AggregationFunctionAdapter;
import io.trino.operator.aggregation.AggregationHeader;
import io.trino.operator.aggregation.AggregationImplementation;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;

public class ParametricAggregation
extends SqlAggregationFunction {
    private final ParametricImplementationsGroup<AggregationImplementation> implementations;
    private final List<AggregationFromAnnotationsParser.AccumulatorStateDetails<?>> stateDetails;

    public ParametricAggregation(Signature signature, AggregationHeader details, List<AggregationFromAnnotationsParser.AccumulatorStateDetails<?>> stateDetails, ParametricImplementationsGroup<AggregationImplementation> implementations) {
        super(ParametricAggregation.createFunctionMetadata(signature, details, implementations.getFunctionNullability()), ParametricAggregation.createAggregationFunctionMetadata(details, stateDetails));
        this.stateDetails = ImmutableList.copyOf((Collection)Objects.requireNonNull(stateDetails, "stateDetails is null"));
        Preconditions.checkArgument((boolean)implementations.getFunctionNullability().isReturnNullable(), (Object)"currently aggregates are required to be nullable");
        this.implementations = Objects.requireNonNull(implementations, "implementations is null");
    }

    private static FunctionMetadata createFunctionMetadata(Signature signature, AggregationHeader details, FunctionNullability functionNullability) {
        FunctionMetadata.Builder functionMetadata = FunctionMetadata.aggregateBuilder().signature(signature).canonicalName(details.getName());
        if (details.getDescription().isPresent()) {
            functionMetadata.description(details.getDescription().get());
        } else {
            functionMetadata.noDescription();
        }
        if (details.isHidden()) {
            functionMetadata.hidden();
        }
        if (details.isDeprecated()) {
            functionMetadata.deprecated();
        }
        if (functionNullability.isReturnNullable()) {
            functionMetadata.nullable();
        }
        functionMetadata.argumentNullability(functionNullability.getArgumentNullable());
        return functionMetadata.build();
    }

    private static AggregationFunctionMetadata createAggregationFunctionMetadata(AggregationHeader details, List<AggregationFromAnnotationsParser.AccumulatorStateDetails<?>> stateDetails) {
        AggregationFunctionMetadata.AggregationFunctionMetadataBuilder builder = AggregationFunctionMetadata.builder();
        if (details.isOrderSensitive()) {
            builder.orderSensitive();
        }
        if (details.isDecomposable()) {
            for (AggregationFromAnnotationsParser.AccumulatorStateDetails<?> stateDetail : stateDetails) {
                builder.intermediateType(stateDetail.getSerializedType());
            }
        }
        return builder.build();
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        ParametricAggregation.declareDependencies(builder, this.implementations.getExactImplementations().values());
        ParametricAggregation.declareDependencies(builder, this.implementations.getSpecializedImplementations());
        ParametricAggregation.declareDependencies(builder, this.implementations.getGenericImplementations());
        for (AggregationFromAnnotationsParser.AccumulatorStateDetails<?> stateDetail : this.stateDetails) {
            for (ImplementationDependency dependency : stateDetail.getDependencies()) {
                dependency.declareDependencies(builder);
            }
        }
        return builder.build();
    }

    private static void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder, Collection<AggregationImplementation> implementations) {
        for (AggregationImplementation implementation : implementations) {
            for (ImplementationDependency dependency : implementation.getInputDependencies()) {
                dependency.declareDependencies(builder);
            }
            for (ImplementationDependency dependency : implementation.getCombineDependencies()) {
                dependency.declareDependencies(builder);
            }
            for (ImplementationDependency dependency : implementation.getOutputDependencies()) {
                dependency.declareDependencies(builder);
            }
        }
    }

    @Override
    public AggregationMetadata specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        AggregationImplementation concreteImplementation = this.findMatchingImplementation(boundSignature);
        FunctionMetadata metadata = this.getFunctionMetadata();
        FunctionBinding functionBinding = SignatureBinder.bindFunction(metadata.getFunctionId(), metadata.getSignature(), boundSignature);
        List accumulatorStateDescriptors = (List)this.stateDetails.stream().map(state -> state.createAccumulatorStateDescriptor(functionBinding, functionDependencies)).collect(ImmutableList.toImmutableList());
        MethodHandle inputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getInputFunction(), concreteImplementation.getInputDependencies(), functionBinding, functionDependencies);
        Optional<MethodHandle> removeInputHandle = concreteImplementation.getRemoveInputFunction().map(removeInputFunction -> ParametricFunctionHelpers.bindDependencies(removeInputFunction, concreteImplementation.getRemoveInputDependencies(), functionBinding, functionDependencies));
        Optional<MethodHandle> combineHandle = concreteImplementation.getCombineFunction();
        if (this.getAggregationMetadata().isDecomposable()) {
            Preconditions.checkArgument((boolean)combineHandle.isPresent(), (String)"Decomposable method %s does not have a combine method", (Object)boundSignature.getName());
            combineHandle = combineHandle.map(combineFunction -> ParametricFunctionHelpers.bindDependencies(combineFunction, concreteImplementation.getCombineDependencies(), functionBinding, functionDependencies));
        } else {
            Preconditions.checkArgument((boolean)concreteImplementation.getCombineFunction().isEmpty(), (String)"Decomposable method %s does not have a combine method", (Object)boundSignature.getName());
        }
        MethodHandle outputHandle = ParametricFunctionHelpers.bindDependencies(concreteImplementation.getOutputFunction(), concreteImplementation.getOutputDependencies(), functionBinding, functionDependencies);
        List<AggregationFunctionAdapter.AggregationParameterKind> inputParameterKinds = concreteImplementation.getInputParameterKinds();
        inputHandle = AggregationFunctionAdapter.normalizeInputMethod(inputHandle, boundSignature, inputParameterKinds);
        removeInputHandle = removeInputHandle.map(function -> AggregationFunctionAdapter.normalizeInputMethod(function, boundSignature, inputParameterKinds));
        return new AggregationMetadata(inputHandle, removeInputHandle, combineHandle, outputHandle, accumulatorStateDescriptors);
    }

    @VisibleForTesting
    public List<AggregationFromAnnotationsParser.AccumulatorStateDetails<?>> getStateDetails() {
        return this.stateDetails;
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<AggregationImplementation> getImplementations() {
        return this.implementations;
    }

    private AggregationImplementation findMatchingImplementation(BoundSignature boundSignature) {
        Signature signature = boundSignature.toSignature();
        Optional<Object> foundImplementation = Optional.empty();
        if (this.implementations.getExactImplementations().containsKey(signature)) {
            foundImplementation = Optional.of(this.implementations.getExactImplementations().get(signature));
        } else {
            for (AggregationImplementation candidate : this.implementations.getGenericImplementations()) {
                if (!candidate.areTypesAssignable(boundSignature)) continue;
                if (foundImplementation.isPresent()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Ambiguous function call (%s) for %s", boundSignature, this.getFunctionMetadata().getSignature()));
                }
                foundImplementation = Optional.of(candidate);
            }
        }
        if (foundImplementation.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", boundSignature, this.getFunctionMetadata().getSignature()));
        }
        return (AggregationImplementation)foundImplementation.get();
    }

    public String toString() {
        return new StringJoiner(", ", ParametricAggregation.class.getSimpleName() + "[", "]").add("signature=" + this.implementations.getSignature()).toString();
    }
}

