/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import io.trino.operator.aggregation.minmaxn.MinMaxNStateFactory;
import io.trino.operator.aggregation.minmaxn.MinNState;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.function.Function;
import java.util.function.LongFunction;

public class MinNStateFactory
implements AccumulatorStateFactory<MinNState> {
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final LongFunction<TypedHeap> heapFactory = n -> {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of min_n must be positive", new Object[0]);
        Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of min_n must be less than or equal to %s; found %s", 10000L, n);
        return new TypedHeap(true, compare, elementType, Math.toIntExact(n));
    };
    private final Function<Block, TypedHeap> deserializer = rowBlock -> TypedHeap.deserialize(true, compare, elementType, rowBlock);

    public MinNStateFactory(@OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_LAST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compare, @TypeParameter(value="T") Type elementType) {
    }

    public MinNState createSingleState() {
        return new SingleMinNState(this.heapFactory, this.deserializer);
    }

    public MinNState createGroupedState() {
        return new GroupedMinNState(this.heapFactory, this.deserializer);
    }

    private static class SingleMinNState
    extends MinMaxNStateFactory.SingleMinMaxNState
    implements MinNState {
        public SingleMinNState(LongFunction<TypedHeap> heapFactory, Function<Block, TypedHeap> deserializer) {
            super(heapFactory, deserializer);
        }

        public SingleMinNState(SingleMinNState state) {
            super(state);
        }

        @Override
        public AccumulatorState copy() {
            return new SingleMinNState(this);
        }
    }

    private static class GroupedMinNState
    extends MinMaxNStateFactory.GroupedMinMaxNState
    implements MinNState {
        public GroupedMinNState(LongFunction<TypedHeap> heapFactory, Function<Block, TypedHeap> deserializer) {
            super(heapFactory, deserializer);
        }
    }
}

