/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.HashGenerator;
import io.trino.operator.Operator;
import io.trino.operator.ProcessorContext;
import io.trino.operator.SpillContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.exchange.LocalPartitionGenerator;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.JoinStatisticsCounter;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupJoinPageBuilder;
import io.trino.operator.join.LookupSource;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.PageJoiner;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spiller.PartitioningSpiller;
import io.trino.spiller.PartitioningSpillerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class DefaultPageJoiner
implements PageJoiner {
    private final List<Type> probeTypes;
    private final JoinProbe.JoinProbeFactory joinProbeFactory;
    private final ListenableFuture<LookupSourceProvider> lookupSourceProviderFuture;
    private final Optional<PartitioningSpillerFactory> partitioningSpillerFactory;
    private final SpillContext spillContext;
    private final MemoryTrackingContext memoryTrackingContext;
    private final JoinStatisticsCounter statisticsCounter;
    private final DriverYieldSignal yieldSignal;
    private final Iterator<SavedRow> savedRows;
    private final Supplier<LocalPartitionGenerator> partitionGenerator;
    private final LookupJoinPageBuilder pageBuilder;
    private final Map<Integer, SavedRow> spilledRows = new HashMap<Integer, SavedRow>();
    private final boolean probeOnOuterSide;
    private final boolean outputSingleMatch;
    @Nullable
    private LookupSourceProvider lookupSourceProvider;
    @Nullable
    private JoinProbe probe;
    private long spillEpoch = 0L;
    private long joinPosition = -1L;
    private int joinSourcePositions;
    private boolean currentProbePositionProducedRow;
    private Optional<PartitioningSpiller> spiller = Optional.empty();
    private ListenableFuture<Void> spillInProgress = Operator.NOT_BLOCKED;

    public DefaultPageJoiner(ProcessorContext processorContext, List<Type> probeTypes, List<Type> buildOutputTypes, LookupJoinOperatorFactory.JoinType joinType, boolean outputSingleMatch, HashGenerator hashGenerator, JoinProbe.JoinProbeFactory joinProbeFactory, LookupSourceFactory lookupSourceFactory, ListenableFuture<LookupSourceProvider> lookupSourceProvider, Optional<PartitioningSpillerFactory> partitioningSpillerFactory, JoinStatisticsCounter statisticsCounter, Iterator<SavedRow> savedRows) {
        Objects.requireNonNull(processorContext, "processorContext is null");
        this.probeTypes = Objects.requireNonNull(probeTypes, "probeTypes is null");
        this.joinProbeFactory = Objects.requireNonNull(joinProbeFactory, "joinProbeFactory is null");
        this.lookupSourceProviderFuture = Objects.requireNonNull(lookupSourceProvider, "lookupSourceProvider is null");
        this.partitioningSpillerFactory = Objects.requireNonNull(partitioningSpillerFactory, "partitioningSpillerFactory is null");
        this.spillContext = processorContext.getSpillContext();
        this.memoryTrackingContext = processorContext.getMemoryTrackingContext();
        this.statisticsCounter = Objects.requireNonNull(statisticsCounter, "statisticsCounter is null");
        this.yieldSignal = processorContext.getDriverYieldSignal();
        this.savedRows = Objects.requireNonNull(savedRows, "savedRows is null");
        this.partitionGenerator = Suppliers.memoize(() -> new LocalPartitionGenerator(hashGenerator, lookupSourceFactory.partitions()));
        this.pageBuilder = new LookupJoinPageBuilder(buildOutputTypes);
        this.outputSingleMatch = outputSingleMatch;
        this.probeOnOuterSide = joinType == LookupJoinOperatorFactory.JoinType.PROBE_OUTER || joinType == LookupJoinOperatorFactory.JoinType.FULL_OUTER;
    }

    @Override
    public Map<Integer, SavedRow> getSpilledRows() {
        return this.spilledRows;
    }

    @Override
    public Optional<PartitioningSpiller> getSpiller() {
        return this.spiller;
    }

    @Override
    public void close() {
        this.pageBuilder.reset();
        MoreFutures.addSuccessCallback(this.lookupSourceProviderFuture, LookupSourceProvider::close);
    }

    @Override
    public WorkProcessor.TransformationState<Page> process(@Nullable Page probePage) {
        Optional<SpillInfoSnapshot> spillInfoSnapshotIfSpillChanged;
        boolean finishing;
        boolean bl = finishing = probePage == null;
        if (this.probe == null) {
            if (!finishing) {
                this.probe = this.joinProbeFactory.createJoinProbe(probePage);
                this.spillEpoch = 0L;
            } else if (this.savedRows.hasNext()) {
                this.restoreProbe(this.savedRows.next());
            } else {
                if (!this.spillInProgress.isDone()) {
                    return WorkProcessor.TransformationState.blocked(this.spillInProgress);
                }
                MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
                this.close();
                return WorkProcessor.TransformationState.finished();
            }
        }
        Verify.verify((this.probe != null ? 1 : 0) != 0, (String)"no probe to work with", (Object[])new Object[0]);
        if (this.lookupSourceProvider == null) {
            if (!this.lookupSourceProviderFuture.isDone()) {
                return WorkProcessor.TransformationState.blocked(DefaultPageJoiner.asVoid(this.lookupSourceProviderFuture));
            }
            this.lookupSourceProvider = Objects.requireNonNull((LookupSourceProvider)MoreFutures.getDone(this.lookupSourceProviderFuture));
            this.statisticsCounter.updateLookupSourcePositions(this.lookupSourceProvider.withLease(lookupSourceLease -> lookupSourceLease.getLookupSource().getJoinPositionCount()));
        }
        if ((spillInfoSnapshotIfSpillChanged = this.processProbe()).isPresent()) {
            if (!this.spillInProgress.isDone()) {
                return WorkProcessor.TransformationState.blocked(this.spillInProgress);
            }
            MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
            if (!this.pageBuilder.isEmpty()) {
                return WorkProcessor.TransformationState.ofResult(this.buildOutputPage(), false);
            }
            this.spillJoinProbe(spillInfoSnapshotIfSpillChanged.get());
        }
        if (!this.probe.isFinished()) {
            if (this.pageBuilder.isFull()) {
                return WorkProcessor.TransformationState.ofResult(this.buildOutputPage(), false);
            }
            return WorkProcessor.TransformationState.yielded();
        }
        if (!this.pageBuilder.isEmpty() || finishing) {
            Page outputPage = this.buildOutputPage();
            this.probe = null;
            return WorkProcessor.TransformationState.ofResult(outputPage, !finishing);
        }
        this.probe = null;
        return WorkProcessor.TransformationState.needsMoreData();
    }

    private Optional<SpillInfoSnapshot> processProbe() {
        return this.lookupSourceProvider.withLease(lookupSourceLease -> {
            if (this.spillEpoch != lookupSourceLease.spillEpoch()) {
                return Optional.of(SpillInfoSnapshot.from(lookupSourceLease));
            }
            this.processProbe(lookupSourceLease.getLookupSource());
            return Optional.empty();
        });
    }

    private void processProbe(LookupSource lookupSource) {
        do {
            if (this.probe.getPosition() < 0) continue;
            if (!this.joinCurrentPosition(lookupSource, this.yieldSignal) || this.probeOnOuterSide && !this.outerJoinCurrentPosition()) break;
            this.statisticsCounter.recordProbe(this.joinSourcePositions);
        } while (this.advanceProbePosition(lookupSource) && !this.yieldSignal.isSet());
    }

    private boolean joinCurrentPosition(LookupSource lookupSource, DriverYieldSignal yieldSignal) {
        while (this.joinPosition >= 0L) {
            if (lookupSource.isJoinPositionEligible(this.joinPosition, this.probe.getPosition(), this.probe.getPage())) {
                this.currentProbePositionProducedRow = true;
                this.pageBuilder.appendRow(this.probe, lookupSource, this.joinPosition);
                ++this.joinSourcePositions;
            }
            this.joinPosition = this.outputSingleMatch && this.currentProbePositionProducedRow ? -1L : lookupSource.getNextJoinPosition(this.joinPosition, this.probe.getPosition(), this.probe.getPage());
            if (!yieldSignal.isSet() && !this.pageBuilder.isFull()) continue;
            return false;
        }
        return true;
    }

    private boolean outerJoinCurrentPosition() {
        if (!this.currentProbePositionProducedRow) {
            this.currentProbePositionProducedRow = true;
            this.pageBuilder.appendNullForBuild(this.probe);
            return !this.pageBuilder.isFull();
        }
        return true;
    }

    private boolean advanceProbePosition(LookupSource lookupSource) {
        if (!this.probe.advanceNextPosition()) {
            return false;
        }
        this.joinPosition = this.probe.getCurrentJoinPosition(lookupSource);
        this.joinSourcePositions = 0;
        this.currentProbePositionProducedRow = false;
        return true;
    }

    private void spillJoinProbe(SpillInfoSnapshot spillInfoSnapshot) {
        Verify.verifyNotNull((Object)this.probe, (String)"probe is null", (Object[])new Object[0]);
        Verify.verify((boolean)this.pageBuilder.isEmpty(), (String)"pageBuilder must be flushed before spill", (Object[])new Object[0]);
        Preconditions.checkArgument((spillInfoSnapshot.getSpillEpoch() > 0L ? 1 : 0) != 0, (Object)"invalid spill epoch");
        if (this.probe.getPosition() < 0) {
            this.probe = this.joinProbeFactory.createJoinProbe(this.spillAndMaskSpilledPositions(this.probe.getPage(), spillInfoSnapshot));
        } else {
            int currentRowPartition = this.partitionGenerator.get().getPartition(this.probe.getPage(), this.probe.getPosition());
            boolean currentRowSpilled = spillInfoSnapshot.getSpillMask().test(currentRowPartition);
            if (currentRowSpilled) {
                this.spilledRows.merge(currentRowPartition, new SavedRow(this.probe.getPage(), this.probe.getPosition(), this.getJoinPositionWithinPartition(), this.currentProbePositionProducedRow, this.joinSourcePositions), (oldValue, newValue) -> {
                    throw new IllegalStateException(String.format("Partition %s is already spilled", currentRowPartition));
                });
                Page remaining = this.pageTail(this.probe.getPage(), this.probe.getPosition() + 1);
                this.probe = this.joinProbeFactory.createJoinProbe(this.spillAndMaskSpilledPositions(remaining, spillInfoSnapshot));
                this.resetProbeRowState();
            } else {
                Page remaining = this.pageTail(this.probe.getPage(), this.probe.getPosition());
                this.probe = this.joinProbeFactory.createJoinProbe(this.spillAndMaskSpilledPositions(remaining, spillInfoSnapshot));
                Verify.verify((boolean)this.probe.advanceNextPosition());
            }
        }
        this.spillEpoch = spillInfoSnapshot.getSpillEpoch();
    }

    private Page spillAndMaskSpilledPositions(Page page, SpillInfoSnapshot spillInfoSnapshot) {
        MoreFutures.checkSuccess(this.spillInProgress, (String)"spilling failed");
        if (this.spiller.isEmpty()) {
            Preconditions.checkState((boolean)this.partitioningSpillerFactory.isPresent(), (Object)"Spiller factory is not present");
            this.spiller = Optional.of(this.partitioningSpillerFactory.get().create(this.probeTypes, this.partitionGenerator.get(), this.spillContext.newLocalSpillContext(), this.memoryTrackingContext.newAggregateUserMemoryContext()));
        }
        PartitioningSpiller.PartitioningSpillResult result = this.spiller.get().partitionAndSpill(page, spillInfoSnapshot.getSpillMask());
        this.spillInProgress = result.getSpillingFuture();
        return result.getRetained();
    }

    private long getJoinPositionWithinPartition() {
        if (this.joinPosition >= 0L) {
            return this.lookupSourceProvider.withLease(lookupSourceLease -> lookupSourceLease.getLookupSource().joinPositionWithinPartition(this.joinPosition));
        }
        return -1L;
    }

    private Page buildOutputPage() {
        Verify.verifyNotNull((Object)this.probe);
        Page outputPage = this.pageBuilder.build(this.probe);
        this.pageBuilder.reset();
        return outputPage;
    }

    private void resetProbeRowState() {
        this.joinPosition = -1L;
        this.joinSourcePositions = 0;
        this.currentProbePositionProducedRow = false;
    }

    private void restoreProbe(SavedRow savedRow) {
        this.probe = this.joinProbeFactory.createJoinProbe(savedRow.row);
        Verify.verify((boolean)this.probe.advanceNextPosition());
        this.joinPosition = savedRow.joinPositionWithinPartition;
        this.currentProbePositionProducedRow = savedRow.currentProbePositionProducedRow;
        this.joinSourcePositions = savedRow.joinSourcePositions;
        this.spillEpoch = 0L;
    }

    private Page pageTail(Page currentPage, int startAtPosition) {
        Verify.verify((currentPage.getPositionCount() - startAtPosition >= 0 ? 1 : 0) != 0);
        return currentPage.getRegion(startAtPosition, currentPage.getPositionCount() - startAtPosition);
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    private static class SpillInfoSnapshot {
        private final long spillEpoch;
        private final IntPredicate spillMask;

        public SpillInfoSnapshot(long spillEpoch, IntPredicate spillMask) {
            this.spillEpoch = spillEpoch;
            this.spillMask = Objects.requireNonNull(spillMask, "spillMask is null");
        }

        public static SpillInfoSnapshot from(LookupSourceProvider.LookupSourceLease lookupSourceLease) {
            return new SpillInfoSnapshot(lookupSourceLease.spillEpoch(), lookupSourceLease.getSpillMask());
        }

        public long getSpillEpoch() {
            return this.spillEpoch;
        }

        public IntPredicate getSpillMask() {
            return this.spillMask;
        }
    }

    public static class SavedRow {
        public final Page row;
        public final long joinPositionWithinPartition;
        public final boolean currentProbePositionProducedRow;
        public final int joinSourcePositions;

        public SavedRow(Page page, int position, long joinPositionWithinPartition, boolean currentProbePositionProducedRow, int joinSourcePositions) {
            this.row = page.getSingleValuePage(position);
            this.joinPositionWithinPartition = joinPositionWithinPartition;
            this.currentProbePositionProducedRow = currentProbePositionProducedRow;
            this.joinSourcePositions = joinSourcePositions;
        }
    }
}

