/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.Lifespan;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.NestedLoopJoinBridge;
import io.trino.operator.join.NestedLoopJoinPages;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class NestedLoopJoinOperator
implements Operator {
    private final ListenableFuture<NestedLoopJoinPages> nestedLoopJoinPagesFuture;
    private final ListenableFuture<Void> blockedFutureView;
    private final OperatorContext operatorContext;
    private final Runnable afterClose;
    private final int[] probeChannels;
    private final int[] buildChannels;
    private List<Page> buildPages;
    private Page probePage;
    private Iterator<Page> buildPageIterator;
    private NestedLoopOutputIterator nestedLoopPageBuilder;
    private boolean finishing;
    private boolean closed;

    private NestedLoopJoinOperator(OperatorContext operatorContext, NestedLoopJoinBridge joinBridge, List<Integer> probeChannels, List<Integer> buildChannels, Runnable afterClose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.nestedLoopJoinPagesFuture = joinBridge.getPagesFuture();
        this.blockedFutureView = NestedLoopJoinOperator.asVoid(this.nestedLoopJoinPagesFuture);
        this.probeChannels = Ints.toArray((Collection)Objects.requireNonNull(probeChannels, "probeChannels is null"));
        this.buildChannels = Ints.toArray((Collection)Objects.requireNonNull(buildChannels, "buildChannels is null"));
        this.afterClose = Objects.requireNonNull(afterClose, "afterClose is null");
    }

    private static <T> ListenableFuture<Void> asVoid(ListenableFuture<T> future) {
        return Futures.transform(future, v -> null, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && this.probePage == null;
        if (finished) {
            this.close();
        }
        return finished;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        return this.blockedFutureView;
    }

    @Override
    public boolean needsInput() {
        Optional nestedLoopJoinPages;
        if (this.finishing || this.probePage != null) {
            return false;
        }
        if (this.buildPages == null && (nestedLoopJoinPages = MoreFutures.tryGetFutureValue(this.nestedLoopJoinPagesFuture)).isPresent()) {
            this.buildPages = ((NestedLoopJoinPages)nestedLoopJoinPages.get()).getPages();
        }
        return this.buildPages != null;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.buildPages != null ? 1 : 0) != 0, (Object)"Page source has not been built yet");
        Preconditions.checkState((this.probePage == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        Preconditions.checkState((this.buildPageIterator == null || !this.buildPageIterator.hasNext() ? 1 : 0) != 0, (Object)"Current buildPageIterator has not been completely processed yet");
        if (page.getPositionCount() > 0) {
            this.probePage = page;
            this.buildPageIterator = this.buildPages.iterator();
        }
    }

    @Override
    public Page getOutput() {
        if (this.probePage == null || this.buildPages == null) {
            return null;
        }
        if (this.nestedLoopPageBuilder != null && this.nestedLoopPageBuilder.hasNext()) {
            return this.nestedLoopPageBuilder.next();
        }
        if (this.buildPageIterator.hasNext()) {
            this.nestedLoopPageBuilder = NestedLoopJoinOperator.createNestedLoopOutputIterator(this.probePage, this.buildPageIterator.next(), this.probeChannels, this.buildChannels);
            return this.nestedLoopPageBuilder.next();
        }
        this.probePage = null;
        this.nestedLoopPageBuilder = null;
        return null;
    }

    @Override
    public void close() {
        this.buildPages = null;
        this.probePage = null;
        this.nestedLoopPageBuilder = null;
        this.buildPageIterator = null;
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.afterClose.run();
    }

    @VisibleForTesting
    static NestedLoopOutputIterator createNestedLoopOutputIterator(Page probePage, Page buildPage, int[] probeChannels, int[] buildChannels) {
        if (probeChannels.length == 0 && buildChannels.length == 0) {
            int probePositions = probePage.getPositionCount();
            int buildPositions = buildPage.getPositionCount();
            try {
                int outputPositions = Math.multiplyExact(probePositions, buildPositions);
                if (outputPositions <= 8192) {
                    return new PageRepeatingIterator(new Page(outputPositions), 1);
                }
            }
            catch (ArithmeticException outputPositions) {
                // empty catch block
            }
            Page outputPage = new Page(Math.max(probePositions, buildPositions));
            return new PageRepeatingIterator(outputPage, Math.min(probePositions, buildPositions));
        }
        if (probeChannels.length == 0 && probePage.getPositionCount() <= buildPage.getPositionCount()) {
            return new PageRepeatingIterator(buildPage.getColumns(buildChannels), probePage.getPositionCount());
        }
        if (buildChannels.length == 0 && buildPage.getPositionCount() <= probePage.getPositionCount()) {
            return new PageRepeatingIterator(probePage.getColumns(probeChannels), buildPage.getPositionCount());
        }
        return new NestedLoopPageBuilder(probePage, buildPage, probeChannels, buildChannels);
    }

    private static final class NestedLoopPageBuilder
    extends NestedLoopOutputIterator {
        private final Block[] resultBlockBuffer;
        private final Block[] smallPageOutputBlocks;
        private final int indexForRleBlocks;
        private final int largePagePositionCount;
        private final int maxRowIndex;
        private int rowIndex = -1;

        NestedLoopPageBuilder(Page probePage, Page buildPage, int[] probeChannels, int[] buildChannels) {
            int i;
            int indexForPageBlocks;
            int[] channelsForSmallPage;
            int[] channelsForLargePage;
            Page smallPage;
            Page largePage;
            Objects.requireNonNull(probePage, "probePage is null");
            Preconditions.checkArgument((probePage.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"probePage has no rows");
            Objects.requireNonNull(buildPage, "buildPage is null");
            Preconditions.checkArgument((buildPage.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"buildPage has no rows");
            if (buildPage.getPositionCount() > probePage.getPositionCount()) {
                largePage = buildPage;
                smallPage = probePage;
                channelsForLargePage = buildChannels;
                channelsForSmallPage = probeChannels;
                indexForPageBlocks = probeChannels.length;
                this.indexForRleBlocks = 0;
            } else {
                largePage = probePage;
                smallPage = buildPage;
                channelsForLargePage = probeChannels;
                channelsForSmallPage = buildChannels;
                indexForPageBlocks = 0;
                this.indexForRleBlocks = probeChannels.length;
            }
            this.largePagePositionCount = largePage.getPositionCount();
            this.maxRowIndex = smallPage.getPositionCount() - 1;
            this.resultBlockBuffer = new Block[channelsForLargePage.length + channelsForSmallPage.length];
            for (i = 0; i < channelsForLargePage.length; ++i) {
                this.resultBlockBuffer[indexForPageBlocks + i] = largePage.getBlock(channelsForLargePage[i]);
            }
            this.smallPageOutputBlocks = new Block[channelsForSmallPage.length];
            for (i = 0; i < channelsForSmallPage.length; ++i) {
                this.smallPageOutputBlocks[i] = smallPage.getBlock(channelsForSmallPage[i]);
            }
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < this.maxRowIndex;
        }

        @Override
        public Page next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.rowIndex;
            for (int i = 0; i < this.smallPageOutputBlocks.length; ++i) {
                Block block = this.smallPageOutputBlocks[i].getSingleValueBlock(this.rowIndex);
                this.resultBlockBuffer[this.indexForRleBlocks + i] = new RunLengthEncodedBlock(block, this.largePagePositionCount);
            }
            return new Page(this.largePagePositionCount, this.resultBlockBuffer);
        }
    }

    private static final class PageRepeatingIterator
    extends NestedLoopOutputIterator {
        private final Page page;
        private int remainingCount;

        private PageRepeatingIterator(Page page, int repetitions) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.remainingCount = repetitions;
        }

        @Override
        public boolean hasNext() {
            return this.remainingCount > 0;
        }

        @Override
        public Page next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.remainingCount;
            return this.page;
        }
    }

    @VisibleForTesting
    static abstract class NestedLoopOutputIterator {
        NestedLoopOutputIterator() {
        }

        public abstract boolean hasNext();

        public abstract Page next();
    }

    public static class NestedLoopJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final JoinBridgeManager<NestedLoopJoinBridge> joinBridgeManager;
        private final List<Integer> probeChannels;
        private final List<Integer> buildChannels;
        private boolean closed;

        public NestedLoopJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager, List<Integer> probeChannels, List<Integer> buildChannels) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.joinBridgeManager = nestedLoopJoinBridgeManager;
            this.joinBridgeManager.incrementProbeFactoryCount();
            this.probeChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(probeChannels, "probeChannels is null"));
            this.buildChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(buildChannels, "buildChannels is null"));
        }

        private NestedLoopJoinOperatorFactory(NestedLoopJoinOperatorFactory other) {
            Objects.requireNonNull(other, "other is null");
            this.operatorId = other.operatorId;
            this.planNodeId = other.planNodeId;
            this.joinBridgeManager = other.joinBridgeManager;
            this.probeChannels = ImmutableList.copyOf(other.probeChannels);
            this.buildChannels = ImmutableList.copyOf(other.buildChannels);
            this.closed = false;
            this.joinBridgeManager.incrementProbeFactoryCount();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            NestedLoopJoinBridge nestedLoopJoinBridge = this.joinBridgeManager.getJoinBridge(driverContext.getLifespan());
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, NestedLoopJoinOperator.class.getSimpleName());
            this.joinBridgeManager.probeOperatorCreated(driverContext.getLifespan());
            return new NestedLoopJoinOperator(operatorContext, nestedLoopJoinBridge, this.probeChannels, this.buildChannels, () -> this.joinBridgeManager.probeOperatorClosed(driverContext.getLifespan()));
        }

        @Override
        public void noMoreOperators() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.joinBridgeManager.probeOperatorFactoryClosedForAllLifespans();
        }

        @Override
        public void noMoreOperators(Lifespan lifespan) {
            this.joinBridgeManager.probeOperatorFactoryClosed(lifespan);
        }

        @Override
        public OperatorFactory duplicate() {
            return new NestedLoopJoinOperatorFactory(this);
        }
    }
}

