/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.Int96ArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class Int96PositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int96PositionsAppender.class).instanceSize();
    private static final Block NULL_VALUE_BLOCK = new Int96ArrayBlock(1, Optional.of(new boolean[]{true}), new long[1], new int[1]);
    private boolean initialized;
    private int initialEntryCount;
    private int positionCount;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private long[] high = new long[0];
    private int[] low = new int[0];
    private long retainedSizeInBytes;
    private long sizeInBytes;

    public Int96PositionsAppender(int expectedEntries) {
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateRetainedSize();
    }

    @Override
    public void append(IntArrayList positions, Block block) {
        if (positions.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((boolean)(block instanceof Int96ArrayBlock));
        int[] positionArray = positions.elements();
        int positionsSize = positions.size();
        this.ensureCapacity(this.positionCount + positionsSize);
        if (block.mayHaveNull()) {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                boolean isNull = block.isNull(position);
                int positionIndex = this.positionCount + i;
                if (isNull) {
                    this.valueIsNull[positionIndex] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.high[positionIndex] = block.getLong(position, 0);
                this.low[positionIndex] = block.getInt(position, 8);
                this.hasNonNullValue = true;
            }
            this.positionCount += positionsSize;
        } else {
            for (int i = 0; i < positionsSize; ++i) {
                int position = positionArray[i];
                this.high[this.positionCount + i] = block.getLong(position, 0);
                this.low[this.positionCount + i] = block.getInt(position, 8);
            }
            this.positionCount += positionsSize;
            this.hasNonNullValue = true;
        }
        this.updateSize(positionsSize);
    }

    @Override
    public void appendRle(RunLengthEncodedBlock block) {
        int rlePositionCount = block.getPositionCount();
        if (rlePositionCount == 0) {
            return;
        }
        int sourcePosition = 0;
        this.ensureCapacity(this.positionCount + rlePositionCount);
        if (block.isNull(sourcePosition)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            this.hasNullValue = true;
        } else {
            long valueHigh = block.getLong(sourcePosition, 0);
            int valueLow = block.getInt(sourcePosition, 8);
            for (int i = 0; i < rlePositionCount; ++i) {
                this.high[this.positionCount + i] = valueHigh;
                this.low[this.positionCount + i] = valueLow;
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += rlePositionCount;
        this.updateSize(rlePositionCount);
    }

    @Override
    public Block build() {
        Object result = this.hasNonNullValue ? new Int96ArrayBlock(this.positionCount, this.hasNullValue ? Optional.of(this.valueIsNull) : Optional.empty(), this.high, this.low) : new RunLengthEncodedBlock(NULL_VALUE_BLOCK, this.positionCount);
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    private void reset() {
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialized = false;
        this.valueIsNull = new boolean[0];
        this.high = new long[0];
        this.low = new int[0];
        this.positionCount = 0;
        this.sizeInBytes = 0L;
        this.hasNonNullValue = false;
        this.hasNullValue = false;
        this.updateRetainedSize();
    }

    private void ensureCapacity(int capacity) {
        int newSize;
        if (this.valueIsNull.length >= capacity) {
            return;
        }
        if (this.initialized) {
            newSize = PositionsAppenderUtil.calculateNewArraySize(this.valueIsNull.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        newSize = Math.max(newSize, capacity);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.high = Arrays.copyOf(this.high, newSize);
        this.low = Arrays.copyOf(this.low, newSize);
        this.updateRetainedSize();
    }

    private void updateSize(long positionsSize) {
        this.sizeInBytes += 13L * positionsSize;
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((long[])this.high) + SizeOf.sizeOf((int[])this.low);
    }
}

