/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.trino.operator.output.BytePositionsAppender;
import io.trino.operator.output.Int128PositionsAppender;
import io.trino.operator.output.Int96PositionsAppender;
import io.trino.operator.output.IntPositionsAppender;
import io.trino.operator.output.LongPositionsAppender;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.RleAwarePositionsAppender;
import io.trino.operator.output.ShortPositionsAppender;
import io.trino.operator.output.SlicePositionsAppender;
import io.trino.operator.output.TypedPositionsAppender;
import io.trino.operator.output.UnnestingPositionsAppender;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VariableWidthType;
import io.trino.type.BlockTypeOperators;
import java.util.Objects;

public class PositionsAppenderFactory {
    private final BlockTypeOperators blockTypeOperators;

    public PositionsAppenderFactory(BlockTypeOperators blockTypeOperators) {
        this.blockTypeOperators = Objects.requireNonNull(blockTypeOperators, "blockTypeOperators is null");
    }

    public PositionsAppender create(Type type, int expectedPositions, long maxPageSizeInBytes) {
        if (!type.isComparable()) {
            return new UnnestingPositionsAppender(this.createPrimitiveAppender(type, expectedPositions, maxPageSizeInBytes));
        }
        return new UnnestingPositionsAppender(new RleAwarePositionsAppender(this.blockTypeOperators.getEqualOperator(type), this.createPrimitiveAppender(type, expectedPositions, maxPageSizeInBytes)));
    }

    private PositionsAppender createPrimitiveAppender(Type type, int expectedPositions, long maxPageSizeInBytes) {
        if (type instanceof FixedWidthType) {
            switch (((FixedWidthType)type).getFixedSize()) {
                case 1: {
                    return new BytePositionsAppender(expectedPositions);
                }
                case 2: {
                    return new ShortPositionsAppender(expectedPositions);
                }
                case 4: {
                    return new IntPositionsAppender(expectedPositions);
                }
                case 8: {
                    return new LongPositionsAppender(expectedPositions);
                }
                case 12: {
                    return new Int96PositionsAppender(expectedPositions);
                }
                case 16: {
                    return new Int128PositionsAppender(expectedPositions);
                }
            }
        } else if (type instanceof VariableWidthType) {
            return new SlicePositionsAppender(expectedPositions, maxPageSizeInBytes);
        }
        return new TypedPositionsAppender(type, expectedPositions);
    }
}

