/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.trino.operator.output.PositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class RleAwarePositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RleAwarePositionsAppender.class).instanceSize();
    private static final int NO_RLE = -1;
    private final BlockTypeOperators.BlockPositionEqual equalOperator;
    private final PositionsAppender delegate;
    @Nullable
    private Block rleValue;
    private int rlePositionCount;

    public RleAwarePositionsAppender(BlockTypeOperators.BlockPositionEqual equalOperator, PositionsAppender delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.equalOperator = Objects.requireNonNull(equalOperator, "equalOperator is null");
    }

    @Override
    public void append(IntArrayList positions, Block source) {
        Preconditions.checkArgument((!(source instanceof RunLengthEncodedBlock) ? 1 : 0) != 0);
        this.switchToFlat();
        this.delegate.append(positions, source);
    }

    @Override
    public void appendRle(RunLengthEncodedBlock source) {
        if (source.getPositionCount() == 0) {
            return;
        }
        if (this.rlePositionCount == 0) {
            this.rleValue = source.getValue();
            this.rlePositionCount = source.getPositionCount();
        } else if (this.rleValue != null) {
            if (this.equalOperator.equalNullSafe(this.rleValue, 0, source.getValue(), 0)) {
                this.rlePositionCount += source.getPositionCount();
                return;
            }
            this.switchToFlat();
            this.delegate.appendRle(source);
        } else {
            this.delegate.appendRle(source);
        }
    }

    @Override
    public Block build() {
        Object result = this.rleValue != null ? new RunLengthEncodedBlock(this.rleValue, this.rlePositionCount) : this.delegate.build();
        this.reset();
        return result;
    }

    private void reset() {
        this.rleValue = null;
        this.rlePositionCount = 0;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedRleSize = this.rleValue != null ? this.rleValue.getRetainedSizeInBytes() : 0L;
        return (long)INSTANCE_SIZE + retainedRleSize + this.delegate.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        long rleSize = this.rleValue != null ? this.rleValue.getSizeInBytes() : 0L;
        return rleSize + this.delegate.getSizeInBytes();
    }

    private void switchToFlat() {
        if (this.rleValue != null) {
            this.delegate.appendRle(new RunLengthEncodedBlock(this.rleValue, this.rlePositionCount));
            this.rleValue = null;
        }
        this.rlePositionCount = -1;
    }
}

