/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.output.PositionsAppender;
import io.trino.operator.output.PositionsAppenderUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class SlicePositionsAppender
implements PositionsAppender {
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SlicePositionsAppender.class).instanceSize();
    private static final Block NULL_VALUE_BLOCK = new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[]{0, 0}, Optional.of(new boolean[]{true}));
    private boolean initialized;
    private int initialEntryCount;
    private int initialBytesSize;
    private byte[] bytes = new byte[0];
    private int currentOffset;
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] offsets = new int[1];
    private int positionCount;
    private long retainedSizeInBytes;
    private long sizeInBytes;

    public SlicePositionsAppender(int expectedEntries, long maxPageSizeInBytes) {
        this(expectedEntries, SlicePositionsAppender.getExpectedBytes(maxPageSizeInBytes, expectedEntries));
    }

    public SlicePositionsAppender(int expectedEntries, int expectedBytes) {
        this.initialEntryCount = expectedEntries;
        this.initialBytesSize = Math.min(expectedBytes, 0x7FFFFFF7);
        this.updateRetainedSize();
    }

    @Override
    public void append(IntArrayList positions, Block block) {
        if (positions.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((boolean)(block instanceof VariableWidthBlock));
        this.ensurePositionCapacity(this.positionCount + positions.size());
        int[] positionArray = positions.elements();
        int newByteCount = 0;
        int[] lengths = new int[positions.size()];
        if (block.mayHaveNull()) {
            for (int i = 0; i < positions.size(); ++i) {
                int length;
                int position = positionArray[i];
                if (block.isNull(position)) {
                    this.offsets[this.positionCount + i + 1] = this.offsets[this.positionCount + i];
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                lengths[i] = length = block.getSliceLength(position);
                newByteCount += length;
                this.offsets[this.positionCount + i + 1] = this.offsets[this.positionCount + i] + length;
                this.hasNonNullValue = true;
            }
        } else {
            for (int i = 0; i < positions.size(); ++i) {
                int length;
                int position = positionArray[i];
                lengths[i] = length = block.getSliceLength(position);
                newByteCount += length;
                this.offsets[this.positionCount + i + 1] = this.offsets[this.positionCount + i] + length;
            }
            this.hasNonNullValue = true;
        }
        this.copyBytes(block, lengths, positionArray, positions.size(), this.offsets, this.positionCount, newByteCount);
    }

    @Override
    public void appendRle(RunLengthEncodedBlock block) {
        int rlePositionCount = block.getPositionCount();
        if (rlePositionCount == 0) {
            return;
        }
        int sourcePosition = 0;
        this.ensurePositionCapacity(this.positionCount + rlePositionCount);
        if (block.isNull(sourcePosition)) {
            int offset = this.offsets[this.positionCount];
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + rlePositionCount, true);
            Arrays.fill(this.offsets, this.positionCount + 1, this.positionCount + rlePositionCount + 1, offset);
            this.positionCount += rlePositionCount;
            this.hasNullValue = true;
            this.updateSize(rlePositionCount, 0);
        } else {
            int startOffset = this.offsets[this.positionCount];
            this.hasNonNullValue = true;
            this.duplicateBytes(block.getValue(), sourcePosition, rlePositionCount, startOffset);
        }
    }

    @Override
    public Block build() {
        Object result = this.hasNonNullValue ? new VariableWidthBlock(this.positionCount, Slices.wrappedBuffer((byte[])this.bytes, (int)0, (int)this.currentOffset), this.offsets, this.hasNullValue ? Optional.of(this.valueIsNull) : Optional.empty()) : new RunLengthEncodedBlock(NULL_VALUE_BLOCK, this.positionCount);
        this.reset();
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    private void copyBytes(Block block, int[] lengths, int[] positions, int count, int[] targetOffsets, int targetOffsetsIndex, int newByteCount) {
        this.ensureBytesCapacity(this.currentOffset + newByteCount);
        for (int i = 0; i < count; ++i) {
            int position = positions[i];
            if (block.isNull(position)) continue;
            int length = lengths[i];
            Slice slice = block.getSlice(position, 0, length);
            slice.getBytes(0, this.bytes, targetOffsets[targetOffsetsIndex + i], length);
        }
        this.positionCount += count;
        this.currentOffset += newByteCount;
        this.updateSize(count, newByteCount);
    }

    private void duplicateBytes(Block block, int position, int count, int startOffset) {
        int length = block.getSliceLength(position);
        int newByteCount = count * length;
        this.ensureBytesCapacity(this.currentOffset + newByteCount);
        Slice slice = block.getSlice(position, 0, length);
        for (int i = 0; i < count; ++i) {
            slice.getBytes(0, this.bytes, startOffset + i * length, length);
            this.offsets[this.positionCount + i + 1] = startOffset + (i + 1) * length;
        }
        this.positionCount += count;
        this.currentOffset += newByteCount;
        this.updateSize(count, newByteCount);
    }

    private void reset() {
        this.initialEntryCount = PositionsAppenderUtil.calculateBlockResetSize(this.positionCount);
        this.initialBytesSize = PositionsAppenderUtil.calculateBlockResetBytes(this.currentOffset);
        this.initialized = false;
        this.valueIsNull = new boolean[0];
        this.offsets = new int[1];
        this.bytes = new byte[0];
        this.positionCount = 0;
        this.currentOffset = 0;
        this.sizeInBytes = 0L;
        this.hasNonNullValue = false;
        this.hasNullValue = false;
        this.updateRetainedSize();
    }

    private void updateSize(long positionsSize, int bytesWritten) {
        this.sizeInBytes += 5L * positionsSize + (long)bytesWritten;
    }

    private void ensureBytesCapacity(int bytesCapacity) {
        if (this.bytes.length < bytesCapacity) {
            int newBytesLength = Math.max(this.bytes.length, this.initialBytesSize);
            if (bytesCapacity > newBytesLength) {
                newBytesLength = Math.max(bytesCapacity, PositionsAppenderUtil.calculateNewArraySize(newBytesLength));
            }
            this.bytes = Arrays.copyOf(this.bytes, newBytesLength);
            this.updateRetainedSize();
        }
    }

    private void ensurePositionCapacity(int capacity) {
        if (this.valueIsNull.length < capacity) {
            int newSize;
            if (this.initialized) {
                newSize = PositionsAppenderUtil.calculateNewArraySize(this.valueIsNull.length);
            } else {
                newSize = this.initialEntryCount;
                this.initialized = true;
            }
            newSize = Math.max(newSize, capacity);
            this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
            this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
            this.updateRetainedSize();
        }
    }

    private void updateRetainedSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((byte[])this.bytes);
    }

    private static int getExpectedBytes(long maxPageSizeInBytes, int expectedPositions) {
        return (int)Math.min((long)expectedPositions * 32L, maxPageSizeInBytes);
    }
}

