/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.trino.operator.output.PositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class TypedPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedPositionsAppender.class).instanceSize();
    private final Type type;
    private BlockBuilder blockBuilder;

    TypedPositionsAppender(Type type, int expectedPositions) {
        this(type, Objects.requireNonNull(type, "type is null").createBlockBuilder(null, expectedPositions));
    }

    TypedPositionsAppender(Type type, BlockBuilder blockBuilder) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.blockBuilder = Objects.requireNonNull(blockBuilder, "blockBuilder is null");
    }

    @Override
    public void append(IntArrayList positions, Block source) {
        int[] positionArray = positions.elements();
        for (int i = 0; i < positions.size(); ++i) {
            this.type.appendTo(source, positionArray[i], this.blockBuilder);
        }
    }

    @Override
    public void appendRle(RunLengthEncodedBlock block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            this.type.appendTo((Block)block, 0, this.blockBuilder);
        }
    }

    @Override
    public Block build() {
        Block result = this.blockBuilder.build();
        this.blockBuilder = this.blockBuilder.newBlockBuilderLike(null);
        return result;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.blockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        return this.blockBuilder.getSizeInBytes();
    }
}

