/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import io.trino.operator.output.PositionsAppender;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class UnnestingPositionsAppender
implements PositionsAppender {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(UnnestingPositionsAppender.class).instanceSize();
    private final PositionsAppender delegate;

    public UnnestingPositionsAppender(PositionsAppender delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public void append(IntArrayList positions, Block source) {
        if (positions.isEmpty()) {
            return;
        }
        if (source instanceof RunLengthEncodedBlock) {
            this.delegate.appendRle(this.flatten((RunLengthEncodedBlock)source, positions.size()));
        } else if (source instanceof DictionaryBlock) {
            this.appendDictionary(positions, (DictionaryBlock)source);
        } else {
            this.delegate.append(positions, source);
        }
    }

    @Override
    public void appendRle(RunLengthEncodedBlock source) {
        if (source.getPositionCount() == 0) {
            return;
        }
        this.delegate.appendRle(this.flatten(source, source.getPositionCount()));
    }

    @Override
    public Block build() {
        return this.delegate.build();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.delegate.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        return this.delegate.getSizeInBytes();
    }

    private void appendDictionary(IntArrayList positions, DictionaryBlock source) {
        Block dictionary = source.getDictionary();
        while (dictionary instanceof RunLengthEncodedBlock || dictionary instanceof DictionaryBlock) {
            if (dictionary instanceof RunLengthEncodedBlock) {
                this.appendRle(new RunLengthEncodedBlock(((RunLengthEncodedBlock)dictionary).getValue(), positions.size()));
                return;
            }
            DictionaryBlock nestedDictionary = (DictionaryBlock)dictionary;
            positions = this.mapPositions(positions, source);
            dictionary = nestedDictionary.getDictionary();
            source = nestedDictionary;
        }
        this.delegate.append(this.mapPositions(positions, source), dictionary);
    }

    private RunLengthEncodedBlock flatten(RunLengthEncodedBlock source, int positionCount) {
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0);
        Block value = source.getValue().getSingleValueBlock(0);
        Preconditions.checkArgument((!(value instanceof DictionaryBlock) && !(value instanceof RunLengthEncodedBlock) ? 1 : 0) != 0, (String)"value must be flat but got %s", (Object)value);
        return new RunLengthEncodedBlock(value, positionCount);
    }

    private IntArrayList mapPositions(IntArrayList positions, DictionaryBlock block) {
        int[] positionArray = new int[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            positionArray[i] = block.getId(positions.getInt(i));
        }
        return IntArrayList.wrap((int[])positionArray);
    }
}

