/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.util.CompilerUtils;
import io.trino.util.Failures;
import io.trino.util.MinMaxCompare;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractGreatestLeast
extends SqlScalarFunction {
    private final boolean min;

    protected AbstractGreatestLeast(boolean min, String description) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(min ? "least" : "greatest").orderableTypeParameter("E").returnType(new TypeSignature("E", new TypeSignatureParameter[0])).argumentType(new TypeSignature("E", new TypeSignatureParameter[0])).variableArity().build()).nullable().argumentNullability(true).description(description).build());
        this.min = min;
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return MinMaxCompare.getMinMaxCompareFunctionDependencies(new TypeSignature("E", new TypeSignatureParameter[0]), this.min);
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Type type = boundSignature.getReturnType();
        Preconditions.checkArgument((boolean)type.isOrderable(), (Object)"Type must be orderable");
        MethodHandle compareMethod = MinMaxCompare.getMinMaxCompare(functionDependencies, type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}), this.min);
        List javaTypes = (List)IntStream.range(0, boundSignature.getArity()).mapToObj(i -> Primitives.wrap((Class)type.getJavaType())).collect(ImmutableList.toImmutableList());
        Class<?> clazz = this.generate(javaTypes, compareMethod);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, this.getFunctionMetadata().getSignature().getName(), javaTypes.toArray(new Class[0]));
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, Collections.nCopies(javaTypes.size(), InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), methodHandle);
    }

    private Class<?> generate(List<Class<?>> javaTypes, MethodHandle compareMethod) {
        Signature signature = this.getFunctionMetadata().getSignature();
        Failures.checkCondition(javaTypes.size() <= 127, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for function call %s()", signature.getName());
        String javaTypeName = javaTypes.stream().map(Class::getSimpleName).collect(Collectors.joining());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(javaTypeName + "$" + signature.getName()), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        List parameters = (List)IntStream.range(0, javaTypes.size()).mapToObj(i -> Parameter.arg((String)("arg" + i), (Class)((Class)javaTypes.get(i)))).collect(ImmutableList.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), signature.getName(), ParameterizedType.type((Class)Primitives.wrap(javaTypes.get(0))), (Iterable)parameters);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        CallSiteBinder binder = new CallSiteBinder();
        Variable value = scope.declareVariable(Primitives.wrap(javaTypes.get(0)), "value");
        BytecodeExpression nullValue = BytecodeExpressions.constantNull((Class)Primitives.wrap(javaTypes.get(0)));
        body.append((BytecodeNode)value.set(nullValue));
        LabelNode done = new LabelNode("done");
        compareMethod = compareMethod.asType(MethodType.methodType(Boolean.TYPE, compareMethod.type().wrap().parameterList()));
        for (int i2 = 0; i2 < javaTypes.size(); ++i2) {
            Parameter parameter = (Parameter)parameters.get(i2);
            BytecodeExpression invokeCompare = BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binder.bind(compareMethod).getBindingId()), (String)"compare", Boolean.TYPE, (BytecodeExpression[])new BytecodeExpression[]{parameter, value});
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.isNull((BytecodeExpression)parameter)).ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)value.set(nullValue)).gotoLabel(done)));
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)value), (BytecodeExpression)invokeCompare)).ifTrue((BytecodeNode)value.set((BytecodeExpression)parameter)));
        }
        body.visitLabel(done);
        body.append((BytecodeNode)value.ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), (ClassLoader)new DynamicClassLoader(this.getClass().getClassLoader()));
    }
}

