/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.lambda.UnaryFunctionInterface;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ApplyFunction
extends SqlScalarFunction {
    public static final ApplyFunction APPLY_FUNCTION = new ApplyFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ApplyFunction.class, "apply", Object.class, UnaryFunctionInterface.class);

    private ApplyFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("apply").typeVariable("T").typeVariable("U").returnType(new TypeSignature("U", new TypeSignatureParameter[0])).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("U", new TypeSignatureParameter[0])})).build()).nullable().argumentNullability(true, false).hidden().description("lambda apply function").build());
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        Type argumentType = boundSignature.getArgumentTypes().get(0);
        Type returnType = boundSignature.getReturnType();
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(UnaryFunctionInterface.class), METHOD_HANDLE.asType(METHOD_HANDLE.type().changeReturnType(Primitives.wrap((Class)returnType.getJavaType())).changeParameterType(0, Primitives.wrap((Class)argumentType.getJavaType()))), Optional.empty());
    }

    @UsedByGeneratedCode
    public static Object apply(Object input, UnaryFunctionInterface function) {
        return function.apply(input);
    }
}

