/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameterSpecialization;
import io.trino.spi.type.Type;
import io.trino.sql.gen.lambda.LambdaFunctionInterface;
import io.trino.util.Failures;
import java.util.Comparator;
import java.util.List;

@ScalarFunction(value="array_sort")
@Description(value="Sorts the given array with a lambda comparator.")
public final class ArraySortComparatorFunction {
    private final PageBuilder pageBuilder;
    private static final int INITIAL_LENGTH = 128;
    private List<Integer> positions = Ints.asList((int[])new int[128]);

    @TypeParameter(value="T")
    public ArraySortComparatorFunction(@TypeParameter(value="T") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="array(T)")
    public Block sortLong(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, integer)") ComparatorLongLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        Comparator comparator = (x, y) -> ArraySortComparatorFunction.comparatorResult(function.apply(block.isNull(x.intValue()) ? null : Long.valueOf(type.getLong(block, x.intValue())), block.isNull(y.intValue()) ? null : Long.valueOf(type.getLong(block, y.intValue()))));
        this.sortPositions(arrayLength, comparator);
        return this.computeResultBlock(type, block, arrayLength);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="array(T)")
    public Block sortDouble(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, integer)") ComparatorDoubleLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        Comparator comparator = (x, y) -> ArraySortComparatorFunction.comparatorResult(function.apply(block.isNull(x.intValue()) ? null : Double.valueOf(type.getDouble(block, x.intValue())), block.isNull(y.intValue()) ? null : Double.valueOf(type.getDouble(block, y.intValue()))));
        this.sortPositions(arrayLength, comparator);
        return this.computeResultBlock(type, block, arrayLength);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="array(T)")
    public Block sortBoolean(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, integer)") ComparatorBooleanLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        Comparator comparator = (x, y) -> ArraySortComparatorFunction.comparatorResult(function.apply(block.isNull(x.intValue()) ? null : Boolean.valueOf(type.getBoolean(block, x.intValue())), block.isNull(y.intValue()) ? null : Boolean.valueOf(type.getBoolean(block, y.intValue()))));
        this.sortPositions(arrayLength, comparator);
        return this.computeResultBlock(type, block, arrayLength);
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Object.class)
    @SqlType(value="array(T)")
    public Block sortObject(@TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block, @SqlType(value="function(T, T, integer)") ComparatorObjectLambda function) {
        int arrayLength = block.getPositionCount();
        this.initPositionsList(arrayLength);
        Comparator comparator = (x, y) -> ArraySortComparatorFunction.comparatorResult(function.apply(block.isNull(x.intValue()) ? null : type.getObject(block, x.intValue()), block.isNull(y.intValue()) ? null : type.getObject(block, y.intValue())));
        this.sortPositions(arrayLength, comparator);
        return this.computeResultBlock(type, block, arrayLength);
    }

    private void initPositionsList(int arrayLength) {
        if (this.positions.size() < arrayLength) {
            this.positions = Ints.asList((int[])new int[arrayLength]);
        }
        for (int i = 0; i < arrayLength; ++i) {
            this.positions.set(i, i);
        }
    }

    private void sortPositions(int arrayLength, Comparator<Integer> comparator) {
        List<Integer> list = this.positions.subList(0, arrayLength);
        try {
            list.sort(comparator);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator violates the comparator contract", (Throwable)e);
        }
    }

    private Block computeResultBlock(Type type, Block block, int arrayLength) {
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < arrayLength; ++i) {
            type.appendTo(block, this.positions.get(i).intValue(), blockBuilder);
        }
        this.pageBuilder.declarePositions(arrayLength);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - arrayLength, arrayLength);
    }

    private static int comparatorResult(Long result) {
        Failures.checkCondition(result != null && (result == -1L || result == 0L || result == 1L), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Lambda comparator must return either -1, 0, or 1", new Object[0]);
        return result.intValue();
    }

    @FunctionalInterface
    public static interface ComparatorObjectLambda
    extends LambdaFunctionInterface {
        public Long apply(Object var1, Object var2);
    }

    @FunctionalInterface
    public static interface ComparatorBooleanLambda
    extends LambdaFunctionInterface {
        public Long apply(Boolean var1, Boolean var2);
    }

    @FunctionalInterface
    public static interface ComparatorDoubleLambda
    extends LambdaFunctionInterface {
        public Long apply(Double var1, Double var2);
    }

    @FunctionalInterface
    public static interface ComparatorLongLambda
    extends LambdaFunctionInterface {
        public Long apply(Long var1, Long var2);
    }
}

