/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ArrayConcatUtils;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class ElementToArrayConcatFunction
extends SqlScalarFunction {
    public static final ElementToArrayConcatFunction ELEMENT_TO_ARRAY_CONCAT_FUNCTION = new ElementToArrayConcatFunction();
    private static final String FUNCTION_NAME = "concat";
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Boolean.TYPE, Block.class);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Long.TYPE, Block.class);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Double.TYPE, Block.class);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Slice.class, Block.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArrayConcatUtils.class, "prependElement", Type.class, Object.class, Block.class);

    public ElementToArrayConcatFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(FUNCTION_NAME).typeVariable("E").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("E", new TypeSignatureParameter[0])).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))).build()).description("Concatenates an element to an array").build());
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        Type type = boundSignature.getArgumentTypes().get(0);
        MethodHandle methodHandle = type.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (type.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (type.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (type.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = methodHandle.bindTo(type);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }
}

