/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.block.Block;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class MapElementAtFunction
extends SqlScalarFunction {
    public static final MapElementAtFunction MAP_ELEMENT_AT = new MapElementAtFunction();
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(MapElementAtFunction.class, "elementAt", Type.class, Block.class, Object.class);

    protected MapElementAtFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("element_at").typeVariable("K").typeVariable("V").returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))).argumentType(new TypeSignature("K", new TypeSignatureParameter[0])).build()).nullable().description("Get value for the given key, or null if it does not exist").build());
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addOperatorSignature(OperatorType.EQUAL, (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]), (Object)new TypeSignature("K", new TypeSignatureParameter[0]))).build();
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        MapType mapType = (MapType)boundSignature.getArgumentType(0);
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        MethodHandle methodHandle = keyType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (keyType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (keyType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : METHOD_HANDLE_OBJECT));
        methodHandle = methodHandle.bindTo(valueType);
        methodHandle = methodHandle.asType(methodHandle.type().changeReturnType(Primitives.wrap((Class)valueType.getJavaType())));
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, boolean key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, long key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, double key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }

    @UsedByGeneratedCode
    public static Object elementAt(Type valueType, Block map, Object key) {
        SingleMapBlock mapBlock = (SingleMapBlock)map;
        int valuePosition = mapBlock.seekKeyExact(key);
        if (valuePosition == -1) {
            return null;
        }
        return TypeUtils.readNativeValue((Type)valueType, (Block)mapBlock, (int)valuePosition);
    }
}

