/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.JsonOperators;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MapToJsonCast
extends SqlScalarFunction {
    public static final MapToJsonCast MAP_TO_JSON = new MapToJsonCast(false);
    public static final MapToJsonCast LEGACY_MAP_TO_JSON = new MapToJsonCast(true);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapToJsonCast.class, "toJson", JsonUtil.ObjectKeyProvider.class, JsonUtil.JsonGeneratorWriter.class, Block.class);
    private final boolean legacyRowToJson;

    private MapToJsonCast(boolean legacyRowToJson) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().operatorType(OperatorType.CAST).castableToTypeParameter("K", VarcharType.VARCHAR.getTypeSignature()).castableToTypeParameter("V", JsonType.JSON.getTypeSignature()).returnType((Type)JsonType.JSON).argumentType(TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))).build()).build());
        this.legacyRowToJson = legacyRowToJson;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        MapType mapType = (MapType)boundSignature.getArgumentType(0);
        Type keyType = mapType.getKeyType();
        Type valueType = mapType.getValueType();
        Failures.checkCondition(JsonUtil.canCastToJson((Type)mapType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast %s to JSON", mapType);
        JsonUtil.ObjectKeyProvider provider = JsonUtil.ObjectKeyProvider.createObjectKeyProvider(keyType);
        JsonUtil.JsonGeneratorWriter writer = JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter(valueType, this.legacyRowToJson);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(provider).bindTo(writer);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Slice toJson(JsonUtil.ObjectKeyProvider provider, JsonUtil.JsonGeneratorWriter writer, Block block) {
        try {
            TreeMap<String, Integer> orderedKeyToValuePosition = new TreeMap<String, Integer>();
            for (int i = 0; i < block.getPositionCount(); i += 2) {
                String objectKey = provider.getObjectKey(block, i);
                orderedKeyToValuePosition.put(objectKey, i + 1);
            }
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : orderedKeyToValuePosition.entrySet()) {
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    writer.writeJsonValue(jsonGenerator, block, (Integer)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

