/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.annotations.VisibleForTesting;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionNullability;
import io.trino.metadata.Signature;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.annotations.ImplementationDependency;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarHeader;
import io.trino.operator.scalar.annotations.ParametricScalarImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.util.Failures;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

public class ParametricScalar
extends SqlScalarFunction {
    private final ParametricImplementationsGroup<ParametricScalarImplementation> implementations;

    public ParametricScalar(Signature signature, ScalarHeader details, ParametricImplementationsGroup<ParametricScalarImplementation> implementations, boolean deprecated) {
        super(ParametricScalar.createFunctionMetadata(signature, details, deprecated, implementations.getFunctionNullability()));
        this.implementations = Objects.requireNonNull(implementations);
    }

    private static FunctionMetadata createFunctionMetadata(Signature signature, ScalarHeader details, boolean deprecated, FunctionNullability functionNullability) {
        FunctionMetadata.Builder functionMetadata = FunctionMetadata.scalarBuilder().signature(signature);
        if (details.getDescription().isPresent()) {
            functionMetadata.description(details.getDescription().get());
        } else {
            functionMetadata.noDescription();
        }
        if (details.isHidden()) {
            functionMetadata.hidden();
        }
        if (!details.isDeterministic()) {
            functionMetadata.nondeterministic();
        }
        if (deprecated) {
            functionMetadata.deprecated();
        }
        if (functionNullability.isReturnNullable()) {
            functionMetadata.nullable();
        }
        functionMetadata.argumentNullability(functionNullability.getArgumentNullable());
        return functionMetadata.build();
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<ParametricScalarImplementation> getImplementations() {
        return this.implementations;
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        ParametricScalar.declareDependencies(builder, this.implementations.getExactImplementations().values());
        ParametricScalar.declareDependencies(builder, this.implementations.getSpecializedImplementations());
        ParametricScalar.declareDependencies(builder, this.implementations.getGenericImplementations());
        return builder.build();
    }

    private static void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder, Collection<ParametricScalarImplementation> implementations) {
        for (ParametricScalarImplementation implementation : implementations) {
            for (ParametricScalarImplementation.ParametricScalarImplementationChoice choice : implementation.getChoices()) {
                for (ImplementationDependency dependency : choice.getDependencies()) {
                    dependency.declareDependencies(builder);
                }
                for (ImplementationDependency dependency : choice.getConstructorDependencies()) {
                    dependency.declareDependencies(builder);
                }
            }
        }
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Optional<ScalarFunctionImplementation> scalarFunctionImplementation;
        FunctionMetadata metadata = this.getFunctionMetadata();
        FunctionBinding functionBinding = SignatureBinder.bindFunction(metadata.getFunctionId(), metadata.getSignature(), boundSignature);
        ParametricScalarImplementation exactImplementation = this.implementations.getExactImplementations().get(boundSignature.toSignature());
        if (exactImplementation != null) {
            Optional<ScalarFunctionImplementation> scalarFunctionImplementation2 = exactImplementation.specialize(functionBinding, functionDependencies);
            Failures.checkCondition(scalarFunctionImplementation2.isPresent(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Exact implementation of %s do not match expected java types.", boundSignature.getName()), new Object[0]);
            return scalarFunctionImplementation2.get();
        }
        ScalarFunctionImplementation selectedImplementation = null;
        for (ParametricScalarImplementation implementation : this.implementations.getSpecializedImplementations()) {
            scalarFunctionImplementation = implementation.specialize(functionBinding, functionDependencies);
            if (!scalarFunctionImplementation.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", metadata.getSignature(), boundSignature);
            selectedImplementation = scalarFunctionImplementation.get();
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        for (ParametricScalarImplementation implementation : this.implementations.getGenericImplementations()) {
            scalarFunctionImplementation = implementation.specialize(functionBinding, functionDependencies);
            if (!scalarFunctionImplementation.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", metadata.getSignature(), boundSignature);
            selectedImplementation = scalarFunctionImplementation.get();
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported binding %s for signature %s", boundSignature, this.getFunctionMetadata().getSignature()));
    }
}

