/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.JsonOperators;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonUtil;
import io.trino.util.Reflection;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;

public class RowToJsonCast
extends SqlScalarFunction {
    public static final RowToJsonCast ROW_TO_JSON = new RowToJsonCast(false);
    public static final RowToJsonCast LEGACY_ROW_TO_JSON = new RowToJsonCast(true);
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowToJsonCast.class, "toJsonObject", List.class, List.class, Block.class);
    private static final MethodHandle LEGACY_METHOD_HANDLE = Reflection.methodHandle(RowToJsonCast.class, "toJsonArray", List.class, Block.class);
    private final boolean legacyRowToJson;

    private RowToJsonCast(boolean legacyRowToJson) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().operatorType(OperatorType.CAST).typeVariableConstraint(TypeVariableConstraint.builder("T").variadicBound("row").castableTo((Type)JsonType.JSON).build()).returnType((Type)JsonType.JSON).argumentType(new TypeSignature("T", new TypeSignatureParameter[0])).build()).build());
        this.legacyRowToJson = legacyRowToJson;
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        MethodHandle methodHandle;
        Type type = boundSignature.getArgumentType(0);
        Failures.checkCondition(JsonUtil.canCastToJson(type), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast %s to JSON", type);
        List fieldTypes = type.getTypeParameters();
        ArrayList<JsonUtil.JsonGeneratorWriter> fieldWriters = new ArrayList<JsonUtil.JsonGeneratorWriter>(fieldTypes.size());
        if (this.legacyRowToJson) {
            for (Type fieldType : fieldTypes) {
                fieldWriters.add(JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter(fieldType, true));
            }
            methodHandle = LEGACY_METHOD_HANDLE.bindTo(fieldWriters);
        } else {
            List typeSignatureParameters = type.getTypeSignature().getParameters();
            ArrayList<String> fieldNames = new ArrayList<String>(fieldTypes.size());
            for (int i = 0; i < fieldTypes.size(); ++i) {
                fieldNames.add(((TypeSignatureParameter)typeSignatureParameters.get(i)).getNamedTypeSignature().getName().orElse(""));
                fieldWriters.add(JsonUtil.JsonGeneratorWriter.createJsonGeneratorWriter((Type)fieldTypes.get(i), false));
            }
            methodHandle = METHOD_HANDLE.bindTo(fieldNames).bindTo(fieldWriters);
        }
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static Slice toJsonObject(List<String> fieldNames, List<JsonUtil.JsonGeneratorWriter> fieldWriters, Block block) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartObject();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    jsonGenerator.writeFieldName(fieldNames.get(i));
                    fieldWriters.get(i).writeJsonValue(jsonGenerator, block, i);
                }
                jsonGenerator.writeEndObject();
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @UsedByGeneratedCode
    public static Slice toJsonArray(List<JsonUtil.JsonGeneratorWriter> fieldWriters, Block block) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(40);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonOperators.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeStartArray();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    fieldWriters.get(i).writeJsonValue(jsonGenerator, block, i);
                }
                jsonGenerator.writeEndArray();
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

