/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.gen.Bootstrap;
import io.trino.sql.gen.CachedInstanceBinder;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.SqlTypeBytecodeExpression;
import io.trino.type.UnknownType;
import io.trino.util.CompilerUtils;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class RowToRowCast
extends SqlScalarFunction {
    private static final MethodHandle OBJECT_IS_NULL;
    private static final MethodHandle BLOCK_IS_NULL;
    private static final MethodHandle WRITE_BOOLEAN;
    private static final MethodHandle WRITE_LONG;
    private static final MethodHandle WRITE_DOUBLE;
    private static final MethodHandle WRITE_OBJECT;
    private static final MethodHandle APPEND_NULL;
    public static final RowToRowCast ROW_TO_ROW_CAST;

    private RowToRowCast() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().operatorType(OperatorType.CAST).typeVariableConstraint(TypeVariableConstraint.builder("F").variadicBound("row").castableTo(new TypeSignature("T", new TypeSignatureParameter[0])).build()).variadicTypeParameter("T", "row").returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentType(new TypeSignature("F", new TypeSignatureParameter[0])).build()).build());
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(BoundSignature boundSignature) {
        List toTypes = boundSignature.getReturnType().getTypeParameters();
        List fromTypes = boundSignature.getArgumentType(0).getTypeParameters();
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        for (int i = 0; i < toTypes.size(); ++i) {
            Type fromElementType = (Type)fromTypes.get(i);
            Type toElementType = (Type)toTypes.get(i);
            builder.addCast(fromElementType, toElementType);
        }
        return builder.build();
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        Type fromType = boundSignature.getArgumentType(0);
        Type toType = boundSignature.getReturnType();
        if (fromType.getTypeParameters().size() != toType.getTypeParameters().size()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "the size of fromType and toType must match");
        }
        Class<?> castOperatorClass = RowToRowCast.generateRowCast(fromType, toType, functionDependencies);
        MethodHandle methodHandle = Reflection.methodHandle(castOperatorClass, "castRow", ConnectorSession.class, Block.class);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    private static Class<?> generateRowCast(Type fromType, Type toType, FunctionDependencies functionDependencies) {
        List toTypes = toType.getTypeParameters();
        List fromTypes = fromType.getTypeParameters();
        CallSiteBinder binder = new CallSiteBinder();
        byte[] hashSuffix = Hashing.goodFastHash((int)128).hashBytes((fromType + "$" + toType).getBytes(StandardCharsets.UTF_8)).asBytes();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(Joiner.on((String)"$").join((Object)"RowCast", (Object)BaseEncoding.base16().encode(hashSuffix), new Object[0])), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter row = Parameter.arg((String)"row", Block.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "castRow", ParameterizedType.type(Block.class), new Parameter[]{session, row});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        Variable singleRowBlockWriter = scope.createTempVariable(BlockBuilder.class);
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantBoolean((boolean)false)));
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        body.append((BytecodeNode)blockBuilder.set(SqlTypeBytecodeExpression.constantType(binder, toType).invoke("createBlockBuilder", BlockBuilder.class, new BytecodeExpression[]{BytecodeExpressions.constantNull(BlockBuilderStatus.class), BytecodeExpressions.constantInt((int)1)})));
        body.append((BytecodeNode)singleRowBlockWriter.set(blockBuilder.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
        for (int i = 0; i < toTypes.size(); ++i) {
            Type fromElementType = (Type)fromTypes.get(i);
            Type toElementType = (Type)toTypes.get(i);
            Type currentFromType = fromElementType;
            if (currentFromType.equals((Object)UnknownType.UNKNOWN)) {
                body.append((BytecodeNode)singleRowBlockWriter.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
                continue;
            }
            MethodHandle castMethod = RowToRowCast.getNullSafeCast(functionDependencies, fromElementType, toElementType);
            MethodHandle writeMethod = RowToRowCast.getNullSafeWrite(toElementType);
            MethodHandle castAndWrite = MethodHandles.collectArguments(writeMethod, 1, castMethod);
            body.append((BytecodeNode)BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binder.bind(castAndWrite).getBindingId()), (String)"castAndWriteField", (MethodType)castAndWrite.type(), (BytecodeExpression[])new BytecodeExpression[]{singleRowBlockWriter, scope.getVariable("session"), row, BytecodeExpressions.constantInt((int)i)}));
        }
        body.append((BytecodeNode)blockBuilder.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        body.append((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, toType).invoke("getObject", Object.class, new BytecodeExpression[]{blockBuilder.cast(Block.class), BytecodeExpressions.constantInt((int)0)}).cast(Block.class).ret());
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), RowToRowCast.class.getClassLoader());
    }

    private static MethodHandle getNullSafeWrite(Type type) {
        MethodHandle writeMethod = type.getJavaType() == Boolean.TYPE ? WRITE_BOOLEAN : (type.getJavaType() == Long.TYPE ? WRITE_LONG : (type.getJavaType() == Double.TYPE ? WRITE_DOUBLE : WRITE_OBJECT));
        writeMethod = writeMethod.bindTo(type);
        writeMethod = MethodHandles.explicitCastArguments(writeMethod, MethodType.methodType(Void.TYPE, BlockBuilder.class, Object.class));
        MethodHandle isNull = MethodHandles.dropArguments(OBJECT_IS_NULL, 0, new Class[]{BlockBuilder.class});
        MethodHandle appendNull = MethodHandles.dropArguments(APPEND_NULL, 1, new Class[]{Object.class}).asType(writeMethod.type());
        return MethodHandles.guardWithTest(isNull, appendNull, writeMethod);
    }

    private static MethodHandle getNullSafeCast(FunctionDependencies functionDependencies, Type fromElementType, Type toElementType) {
        MethodHandle castMethod = functionDependencies.getCastInvoker(fromElementType, toElementType, new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, true, false)).getMethodHandle();
        if (!castMethod.type().parameterType(0).equals(ConnectorSession.class)) {
            castMethod = MethodHandles.dropArguments(castMethod, 0, new Class[]{ConnectorSession.class});
        }
        castMethod = castMethod.asType(MethodType.methodType(Object.class, ConnectorSession.class, Block.class, Integer.TYPE));
        return MethodHandles.guardWithTest(MethodHandles.dropArguments(BLOCK_IS_NULL, 0, new Class[]{ConnectorSession.class}), MethodHandles.dropArguments(MethodHandles.zero(Object.class), 0, castMethod.type().parameterList()), castMethod);
    }

    static {
        try {
            OBJECT_IS_NULL = MethodHandles.lookup().findStatic(Objects.class, "isNull", MethodType.methodType(Boolean.TYPE, Object.class));
            BLOCK_IS_NULL = MethodHandles.lookup().findVirtual(Block.class, "isNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
            WRITE_BOOLEAN = MethodHandles.lookup().findVirtual(Type.class, "writeBoolean", MethodType.methodType(Void.TYPE, BlockBuilder.class, Boolean.TYPE));
            WRITE_LONG = MethodHandles.lookup().findVirtual(Type.class, "writeLong", MethodType.methodType(Void.TYPE, BlockBuilder.class, Long.TYPE));
            WRITE_DOUBLE = MethodHandles.lookup().findVirtual(Type.class, "writeDouble", MethodType.methodType(Void.TYPE, BlockBuilder.class, Double.TYPE));
            WRITE_OBJECT = MethodHandles.lookup().findVirtual(Type.class, "writeObject", MethodType.methodType(Void.TYPE, BlockBuilder.class, Object.class));
            APPEND_NULL = MethodHandles.lookup().findVirtual(BlockBuilder.class, "appendNull", MethodType.methodType(BlockBuilder.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
        ROW_TO_ROW_CAST = new RowToRowCast();
    }
}

