/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class VersionFunction
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(VersionFunction.class, "getVersion", String.class);
    private final String nodeVersion;

    public VersionFunction(String nodeVersion) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name("version").returnType((Type)VarcharType.VARCHAR).build()).hidden().description("Return server version").build());
        this.nodeVersion = nodeVersion;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.nodeVersion);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of(), methodHandle);
    }

    @UsedByGeneratedCode
    public static Slice getVersion(String version) {
        return Slices.utf8Slice((String)version);
    }
}

