/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.json.JsonInputErrorNode;
import io.trino.json.JsonPathEvaluator;
import io.trino.json.JsonPathInvocationContext;
import io.trino.json.PathEvaluationError;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.operator.scalar.json.JsonInputConversionError;
import io.trino.operator.scalar.json.ParameterUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.tree.JsonExists;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonExistsFunction
extends SqlScalarFunction {
    public static final String JSON_EXISTS_FUNCTION_NAME = "$json_exists";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonExistsFunction.class, "jsonExists", FunctionManager.class, Metadata.class, TypeManager.class, Type.class, JsonPathInvocationContext.class, ConnectorSession.class, JsonNode.class, IrJsonPath.class, Block.class, Long.TYPE);
    private static final TrinoException INPUT_ARGUMENT_ERROR = new JsonInputConversionError("malformed input argument to JSON_EXISTS function");
    private static final TrinoException PATH_PARAMETER_ERROR = new JsonInputConversionError("malformed JSON path parameter to JSON_EXISTS function");
    private final FunctionManager functionManager;
    private final Metadata metadata;
    private final TypeManager typeManager;

    public JsonExistsFunction(FunctionManager functionManager, Metadata metadata, TypeManager typeManager) {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(JSON_EXISTS_FUNCTION_NAME).typeVariable("T").returnType((Type)BooleanType.BOOLEAN).argumentTypes((List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("json2016", new TypeSignatureParameter[0]), (Object)new TypeSignature("JsonPath2016", new TypeSignatureParameter[0]), (Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)new TypeSignature("tinyint", new TypeSignatureParameter[0]))).build()).nullable().argumentNullability(false, false, true, false).hidden().description("Determines whether a JSON value satisfies a path specification").build());
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        Type parametersRowType = boundSignature.getArgumentType(2);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.functionManager).bindTo(this.metadata).bindTo(this.typeManager).bindTo(parametersRowType);
        MethodHandle instanceFactory = Reflection.constructorMethodHandle(JsonPathInvocationContext.class, new Class[0]);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle, Optional.of(instanceFactory));
    }

    @UsedByGeneratedCode
    public static Boolean jsonExists(FunctionManager functionManager, Metadata metadata, TypeManager typeManager, Type parametersRowType, JsonPathInvocationContext invocationContext, ConnectorSession session, JsonNode inputExpression, IrJsonPath jsonPath, Block parametersRow, long errorBehavior) {
        List<Object> pathResult;
        Object[] parameters;
        if (inputExpression.equals((Object)JsonInputErrorNode.JSON_ERROR)) {
            return JsonExistsFunction.handleError(errorBehavior, INPUT_ARGUMENT_ERROR);
        }
        for (Object parameter : parameters = ParameterUtil.getParametersArray(parametersRowType, parametersRow)) {
            if (!parameter.equals((Object)JsonInputErrorNode.JSON_ERROR)) continue;
            return JsonExistsFunction.handleError(errorBehavior, PATH_PARAMETER_ERROR);
        }
        JsonPathEvaluator evaluator = invocationContext.getEvaluator();
        if (evaluator == null) {
            evaluator = new JsonPathEvaluator(jsonPath, session, metadata, typeManager, functionManager);
            invocationContext.setEvaluator(evaluator);
        }
        try {
            pathResult = evaluator.evaluate(inputExpression, parameters);
        }
        catch (PathEvaluationError e) {
            return JsonExistsFunction.handleError(errorBehavior, e);
        }
        return !pathResult.isEmpty();
    }

    private static Boolean handleError(long errorBehavior, TrinoException error) {
        switch (JsonExists.ErrorBehavior.values()[(int)errorBehavior]) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case UNKNOWN: {
                return null;
            }
            case ERROR: {
                throw error;
            }
        }
        throw new IllegalStateException("unexpected error behavior");
    }
}

