/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.json.JsonInputErrorNode;
import io.trino.json.ir.SqlJsonLiteralConverter;
import io.trino.json.ir.TypedValue;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.type.Json2016Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.List;

public class JsonObjectFunction
extends SqlScalarFunction {
    public static final JsonObjectFunction JSON_OBJECT_FUNCTION = new JsonObjectFunction();
    public static final String JSON_OBJECT_FUNCTION_NAME = "$json_object";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonObjectFunction.class, "jsonObject", RowType.class, RowType.class, Block.class, Block.class, Boolean.TYPE, Boolean.TYPE);
    private static final JsonNode EMPTY_OBJECT = new ObjectNode(JsonNodeFactory.instance);

    private JsonObjectFunction() {
        super(FunctionMetadata.scalarBuilder().signature(Signature.builder().name(JSON_OBJECT_FUNCTION_NAME).typeVariable("K").typeVariable("V").returnType(new TypeSignature("json2016", new TypeSignatureParameter[0])).argumentTypes((List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("K", new TypeSignatureParameter[0]), (Object)new TypeSignature("V", new TypeSignatureParameter[0]), (Object)new TypeSignature("boolean", new TypeSignatureParameter[0]), (Object)new TypeSignature("boolean", new TypeSignatureParameter[0]))).build()).argumentNullability(true, true, false, false).hidden().description("Creates a JSON object from key-value pairs").build());
    }

    @Override
    protected ScalarFunctionImplementation specialize(BoundSignature boundSignature) {
        RowType keysRowType = (RowType)boundSignature.getArgumentType(0);
        RowType valuesRowType = (RowType)boundSignature.getArgumentType(1);
        Preconditions.checkArgument((keysRowType.getFields().size() == valuesRowType.getFields().size() ? 1 : 0) != 0, (Object)"keys and values do not match");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(keysRowType).bindTo(valuesRowType);
        return new ChoicesScalarFunctionImplementation(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static JsonNode jsonObject(RowType keysRowType, RowType valuesRowType, Block keysRow, Block valuesRow, boolean nullOnNull, boolean uniqueKeys) {
        if (ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)keysRowType)) {
            return EMPTY_OBJECT;
        }
        HashMap<String, NullNode> members = new HashMap<String, NullNode>();
        List keys = keysRow.getChildren();
        List values = valuesRow.getChildren();
        for (int i = 0; i < keysRowType.getFields().size(); ++i) {
            NullNode valueNode;
            Type keyType = ((RowType.Field)keysRowType.getFields().get(i)).getType();
            Object key = TypeUtils.readNativeValue((Type)keyType, (Block)((Block)keys.get(i)), (int)0);
            if (key == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "null value passed for JSON object key to JSON_OBJECT function");
            }
            String keyName = ((Slice)key).toStringUtf8();
            Type valueType = ((RowType.Field)valuesRowType.getFields().get(i)).getType();
            Object value = TypeUtils.readNativeValue((Type)valueType, (Block)((Block)values.get(i)), (int)0);
            Preconditions.checkState((!JsonInputErrorNode.JSON_ERROR.equals(value) ? 1 : 0) != 0, (Object)"malformed JSON error suppressed in the input function");
            if (value == null) {
                if (!nullOnNull) continue;
                valueNode = NullNode.getInstance();
            } else {
                valueNode = valueType.equals((Object)Json2016Type.JSON_2016) ? (JsonNode)value : SqlJsonLiteralConverter.getJsonNode(TypedValue.fromValueAsObject(valueType, value)).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "value passed to JSON_OBJECT function cannot be converted to JSON"));
            }
            if (members.put(keyName, valueNode) == null) continue;
            if (uniqueKeys) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "duplicate key passed to JSON_OBJECT function");
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "cannot construct a JSON object with duplicate key");
        }
        return new ObjectNode(JsonNodeFactory.instance, members);
    }
}

