/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.json.JsonOutputConversionError;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.sql.tree.JsonQuery;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class JsonOutputFunctions {
    public static final String JSON_TO_VARCHAR = "$json_to_varchar";
    public static final String JSON_TO_VARBINARY = "$json_to_varbinary";
    public static final String JSON_TO_VARBINARY_UTF8 = "$json_to_varbinary_utf8";
    public static final String JSON_TO_VARBINARY_UTF16 = "$json_to_varbinary_utf16";
    public static final String JSON_TO_VARBINARY_UTF32 = "$json_to_varbinary_utf32";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final EncodingSpecificConstants UTF_8 = new EncodingSpecificConstants(JsonEncoding.UTF8, StandardCharsets.UTF_8, Slices.copiedBuffer((String)new ArrayNode(JsonNodeFactory.instance).asText(), (Charset)StandardCharsets.UTF_8), Slices.copiedBuffer((String)new ObjectNode(JsonNodeFactory.instance).asText(), (Charset)StandardCharsets.UTF_8));
    private static final EncodingSpecificConstants UTF_16 = new EncodingSpecificConstants(JsonEncoding.UTF16_LE, StandardCharsets.UTF_16LE, Slices.copiedBuffer((String)new ArrayNode(JsonNodeFactory.instance).asText(), (Charset)StandardCharsets.UTF_16LE), Slices.copiedBuffer((String)new ObjectNode(JsonNodeFactory.instance).asText(), (Charset)StandardCharsets.UTF_16LE));
    private static final EncodingSpecificConstants UTF_32 = new EncodingSpecificConstants(JsonEncoding.UTF32_LE, Charset.forName("UTF-32LE"), Slices.copiedBuffer((String)new ArrayNode(JsonNodeFactory.instance).asText(), (Charset)Charset.forName("UTF-32LE")), Slices.copiedBuffer((String)new ObjectNode(JsonNodeFactory.instance).asText(), (Charset)Charset.forName("UTF-32LE")));

    private JsonOutputFunctions() {
    }

    @SqlNullable
    @ScalarFunction(value="$json_to_varchar", hidden=true)
    @SqlType(value="varchar")
    public static Slice jsonToVarchar(@SqlType(value="json2016") JsonNode jsonExpression, @SqlType(value="tinyint") long errorBehavior, @SqlType(value="boolean") boolean omitQuotes) {
        return JsonOutputFunctions.serialize(jsonExpression, UTF_8, errorBehavior, omitQuotes);
    }

    @SqlNullable
    @ScalarFunction(value="$json_to_varbinary", hidden=true)
    @SqlType(value="varbinary")
    public static Slice jsonToVarbinary(@SqlType(value="json2016") JsonNode jsonExpression, @SqlType(value="tinyint") long errorBehavior, @SqlType(value="boolean") boolean omitQuotes) {
        return JsonOutputFunctions.jsonToVarbinaryUtf8(jsonExpression, errorBehavior, omitQuotes);
    }

    @SqlNullable
    @ScalarFunction(value="$json_to_varbinary_utf8", hidden=true)
    @SqlType(value="varbinary")
    public static Slice jsonToVarbinaryUtf8(@SqlType(value="json2016") JsonNode jsonExpression, @SqlType(value="tinyint") long errorBehavior, @SqlType(value="boolean") boolean omitQuotes) {
        return JsonOutputFunctions.serialize(jsonExpression, UTF_8, errorBehavior, omitQuotes);
    }

    @SqlNullable
    @ScalarFunction(value="$json_to_varbinary_utf16", hidden=true)
    @SqlType(value="varbinary")
    public static Slice jsonToVarbinaryUtf16(@SqlType(value="json2016") JsonNode jsonExpression, @SqlType(value="tinyint") long errorBehavior, @SqlType(value="boolean") boolean omitQuotes) {
        return JsonOutputFunctions.serialize(jsonExpression, UTF_16, errorBehavior, omitQuotes);
    }

    @SqlNullable
    @ScalarFunction(value="$json_to_varbinary_utf32", hidden=true)
    @SqlType(value="varbinary")
    public static Slice jsonToVarbinaryUtf32(@SqlType(value="json2016") JsonNode jsonExpression, @SqlType(value="tinyint") long errorBehavior, @SqlType(value="boolean") boolean omitQuotes) {
        return JsonOutputFunctions.serialize(jsonExpression, UTF_32, errorBehavior, omitQuotes);
    }

    private static Slice serialize(JsonNode json, EncodingSpecificConstants constants, long errorBehavior, boolean omitQuotes) {
        if (omitQuotes && json.isTextual()) {
            return Slices.copiedBuffer((String)json.asText(), (Charset)constants.charset);
        }
        ByteArrayBuilder builder = new ByteArrayBuilder();
        try (JsonGenerator generator = MAPPER.createGenerator((OutputStream)builder, constants.jsonEncoding);){
            MAPPER.writeTree(generator, json);
        }
        catch (JsonProcessingException e) {
            if (errorBehavior == (long)JsonQuery.EmptyOrErrorBehavior.NULL.ordinal()) {
                return null;
            }
            if (errorBehavior == (long)JsonQuery.EmptyOrErrorBehavior.ERROR.ordinal()) {
                throw new JsonOutputConversionError(e);
            }
            if (errorBehavior == (long)JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY.ordinal()) {
                return constants.emptyArray;
            }
            if (errorBehavior == (long)JsonQuery.EmptyOrErrorBehavior.EMPTY_OBJECT.ordinal()) {
                return constants.emptyObject;
            }
            throw new IllegalStateException("unexpected behavior");
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
        return Slices.wrappedBuffer((byte[])builder.toByteArray());
    }

    private static class EncodingSpecificConstants {
        private final JsonEncoding jsonEncoding;
        private final Charset charset;
        private final Slice emptyArray;
        private final Slice emptyObject;

        public EncodingSpecificConstants(JsonEncoding jsonEncoding, Charset charset, Slice emptyArray, Slice emptyObject) {
            this.jsonEncoding = Objects.requireNonNull(jsonEncoding, "jsonEncoding is null");
            this.charset = Objects.requireNonNull(charset, "charset is null");
            this.emptyArray = Objects.requireNonNull(emptyArray, "emptyArray is null");
            this.emptyObject = Objects.requireNonNull(emptyObject, "emptyObject is null");
        }
    }
}

