/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.operator.scalar.StringFunctions;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestamp;
import io.trino.type.DateTimes;
import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;

@ScalarOperator(value=OperatorType.CAST)
public final class VarcharToTimestampCast {
    private VarcharToTimestampCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static long castToShort(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice value) {
        try {
            return VarcharToTimestampCast.castToShortTimestamp((int)precision, StringFunctions.trim(value).toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp castToLong(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice value) {
        try {
            return VarcharToTimestampCast.castToLongTimestamp((int)precision, StringFunctions.trim(value).toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @VisibleForTesting
    public static long castToShortTimestamp(int precision, String value) {
        long epochSecond;
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (Object)"precision must be less than max short timestamp precision");
        Matcher matcher = DateTimes.DATETIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value);
        }
        String year = matcher.group("year");
        String month = matcher.group("month");
        String day = matcher.group("day");
        String hour = matcher.group("hour");
        String minute = matcher.group("minute");
        String second = matcher.group("second");
        String fraction = matcher.group("fraction");
        try {
            epochSecond = ZonedDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), hour == null ? 0 : Integer.parseInt(hour), minute == null ? 0 : Integer.parseInt(minute), second == null ? 0 : Integer.parseInt(second), 0, ZoneOffset.UTC).toEpochSecond();
        }
        catch (DateTimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value, (Throwable)e);
        }
        int actualPrecision = 0;
        long fractionValue = 0L;
        if (fraction != null) {
            actualPrecision = fraction.length();
            fractionValue = Long.parseLong(fraction);
        }
        if (actualPrecision > precision) {
            fractionValue = DateTimes.round(fractionValue, actualPrecision - precision);
        }
        return epochSecond * 1000000L + DateTimes.rescale(fractionValue, actualPrecision, 6);
    }

    @VisibleForTesting
    public static LongTimestamp castToLongTimestamp(int precision, String value) {
        long epochSecond;
        Preconditions.checkArgument((precision > 6 && precision <= 12 ? 1 : 0) != 0, (Object)"precision out of range");
        Matcher matcher = DateTimes.DATETIME_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value);
        }
        String year = matcher.group("year");
        String month = matcher.group("month");
        String day = matcher.group("day");
        String hour = matcher.group("hour");
        String minute = matcher.group("minute");
        String second = matcher.group("second");
        String fraction = matcher.group("fraction");
        try {
            epochSecond = ZonedDateTime.of(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day), hour == null ? 0 : Integer.parseInt(hour), minute == null ? 0 : Integer.parseInt(minute), second == null ? 0 : Integer.parseInt(second), 0, ZoneOffset.UTC).toEpochSecond();
        }
        catch (DateTimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to timestamp: " + value, (Throwable)e);
        }
        int actualPrecision = 0;
        long fractionValue = 0L;
        if (fraction != null) {
            actualPrecision = fraction.length();
            fractionValue = Long.parseLong(fraction);
        }
        if (actualPrecision > precision) {
            fractionValue = DateTimes.round(fractionValue, actualPrecision - precision);
        }
        return DateTimes.longTimestamp(epochSecond, DateTimes.rescale(fractionValue, actualPrecision, 12));
    }
}

