/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import io.trino.metadata.BoundSignature;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlFunction;
import io.trino.operator.window.WindowFunctionSupplier;
import java.util.Objects;
import java.util.Optional;

public class SqlWindowFunction
implements SqlFunction {
    private final WindowFunctionSupplier supplier;
    private final FunctionMetadata functionMetadata;

    public SqlWindowFunction(Signature signature, Optional<String> description, boolean deprecated, WindowFunctionSupplier supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier is null");
        FunctionMetadata.Builder functionMetadata = FunctionMetadata.windowBuilder().signature(signature);
        if (description.isPresent()) {
            functionMetadata.description(description.get());
        } else {
            functionMetadata.noDescription();
        }
        if (deprecated) {
            functionMetadata.deprecated();
        }
        this.functionMetadata = functionMetadata.build();
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public WindowFunctionSupplier specialize(BoundSignature boundSignature, FunctionDependencies functionDependencies) {
        return this.specialize(boundSignature);
    }

    public WindowFunctionSupplier specialize(BoundSignature boundSignature) {
        return this.supplier;
    }
}

