/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.connector.CatalogName;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PluginClassLoader
extends URLClassLoader {
    private final String pluginName;
    private final Optional<CatalogName> catalogName;
    private final ClassLoader spiClassLoader;
    private final List<String> spiPackages;
    private final List<String> spiResources;

    public PluginClassLoader(String pluginName, List<URL> urls, ClassLoader spiClassLoader, List<String> spiPackages) {
        this(pluginName, Optional.empty(), urls, spiClassLoader, spiPackages, (Iterable)spiPackages.stream().map(PluginClassLoader::classNameToResource).collect(ImmutableList.toImmutableList()));
    }

    private PluginClassLoader(String pluginName, Optional<CatalogName> catalogName, List<URL> urls, ClassLoader spiClassLoader, Iterable<String> spiPackages, Iterable<String> spiResources) {
        super(urls.toArray(new URL[0]), PluginClassLoader.getPlatformClassLoader());
        this.pluginName = Objects.requireNonNull(pluginName, "pluginName is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.spiClassLoader = Objects.requireNonNull(spiClassLoader, "spiClassLoader is null");
        this.spiPackages = ImmutableList.copyOf(spiPackages);
        this.spiResources = ImmutableList.copyOf(spiResources);
    }

    public PluginClassLoader duplicate(CatalogName catalogName) {
        Preconditions.checkState((boolean)this.catalogName.isEmpty(), (Object)"class loader is already a duplicate");
        return new PluginClassLoader(this.pluginName, Optional.of(Objects.requireNonNull(catalogName, "catalogName is null")), (List<URL>)ImmutableList.copyOf((Object[])this.getURLs()), this.spiClassLoader, this.spiPackages, this.spiResources);
    }

    public PluginClassLoader withUrl(URL url) {
        ImmutableList urls = ImmutableList.builder().add((Object[])this.getURLs()).add((Object)url).build();
        return new PluginClassLoader(this.pluginName, this.catalogName, (List<URL>)urls, this.spiClassLoader, this.spiPackages, this.spiResources);
    }

    public String getId() {
        return this.pluginName + this.catalogName.map(name -> ":" + name).orElse("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> cachedClass = this.findLoadedClass(name);
            if (cachedClass != null) {
                return this.resolveClass(cachedClass, resolve);
            }
            if (this.isSpiClass(name)) {
                return this.resolveClass(this.spiClassLoader.loadClass(name), resolve);
            }
            return super.loadClass(name, resolve);
        }
    }

    private Class<?> resolveClass(Class<?> clazz, boolean resolve) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        if (this.isSpiResource(name)) {
            return this.spiClassLoader.getResource(name);
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isSpiClass(name)) {
            return this.spiClassLoader.getResources(name);
        }
        return super.getResources(name);
    }

    private boolean isSpiClass(String name) {
        return this.spiPackages.stream().anyMatch(name::startsWith);
    }

    private boolean isSpiResource(String name) {
        return this.spiResources.stream().anyMatch(name::startsWith);
    }

    private static String classNameToResource(String className) {
        return className.replace('.', '/');
    }
}

