/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.trino.server.security.oauth2.ChallengeFailedException;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public interface OAuth2Client {
    public void load();

    public Request createAuthorizationRequest(String var1, URI var2);

    public Response getOAuth2Response(String var1, URI var2, Optional<String> var3) throws ChallengeFailedException;

    public Optional<Map<String, Object>> getClaims(String var1);

    public static class Response {
        private final String accessToken;
        private final Instant expiration;
        private final Optional<String> idToken;

        public Response(String accessToken, Instant expiration, Optional<String> idToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken is null");
            this.expiration = Objects.requireNonNull(expiration, "expiration is null");
            this.idToken = Objects.requireNonNull(idToken, "idToken is null");
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Instant getExpiration() {
            return this.expiration;
        }

        public Optional<String> getIdToken() {
            return this.idToken;
        }
    }

    public static class Request {
        private final URI authorizationUri;
        private final Optional<String> nonce;

        public Request(URI authorizationUri, Optional<String> nonce) {
            this.authorizationUri = Objects.requireNonNull(authorizationUri, "authorizationUri is null");
            this.nonce = Objects.requireNonNull(nonce, "nonce is null");
        }

        public URI getAuthorizationUri() {
            return this.authorizationUri;
        }

        public Optional<String> getNonce() {
            return this.nonce;
        }
    }
}

