/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.execution.TaskId;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class RemoteSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RemoteSplit.class).instanceSize();
    private final ExchangeInput exchangeInput;

    @JsonCreator
    public RemoteSplit(@JsonProperty(value="exchangeInput") ExchangeInput exchangeInput) {
        this.exchangeInput = Objects.requireNonNull(exchangeInput, "remoteSplitInput is null");
    }

    @JsonProperty
    public ExchangeInput getExchangeInput() {
        return this.exchangeInput;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exchangeInput", (Object)this.exchangeInput).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.exchangeInput.getRetainedSizeInBytes();
    }

    public static class SpoolingExchangeInput
    implements ExchangeInput {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SpoolingExchangeInput.class).instanceSize();
        private final List<ExchangeSourceHandle> exchangeSourceHandles;

        @JsonCreator
        public SpoolingExchangeInput(@JsonProperty(value="exchangeSourceHandles") List<ExchangeSourceHandle> exchangeSourceHandles) {
            this.exchangeSourceHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(exchangeSourceHandles, "exchangeSourceHandles is null"));
        }

        @JsonProperty
        public List<ExchangeSourceHandle> getExchangeSourceHandles() {
            return this.exchangeSourceHandles;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("exchangeSourceHandles", this.exchangeSourceHandles).toString();
        }

        @Override
        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.exchangeSourceHandles, ExchangeSourceHandle::getRetainedSizeInBytes);
        }
    }

    public static class DirectExchangeInput
    implements ExchangeInput {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(DirectExchangeInput.class).instanceSize();
        private final TaskId taskId;
        private final String location;

        @JsonCreator
        public DirectExchangeInput(@JsonProperty(value="taskId") TaskId taskId, @JsonProperty(value="location") String location) {
            this.taskId = Objects.requireNonNull(taskId, "taskId is null");
            this.location = Objects.requireNonNull(location, "location is null");
        }

        @JsonProperty
        public TaskId getTaskId() {
            return this.taskId;
        }

        @JsonProperty
        public String getLocation() {
            return this.location;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("taskId", (Object)this.taskId).add("location", (Object)this.location).toString();
        }

        @Override
        public long getRetainedSizeInBytes() {
            return (long)INSTANCE_SIZE + this.taskId.getRetainedSizeInBytes() + SizeOf.estimatedSizeOf((String)this.location);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=DirectExchangeInput.class, name="direct"), @JsonSubTypes.Type(value=SpoolingExchangeInput.class, name="spool")})
    public static interface ExchangeInput {
        public long getRetainedSizeInBytes();
    }
}

