/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.sql.planner.DynamicFilterSourceConsumer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;

public class LocalDynamicFilterConsumer
implements DynamicFilterSourceConsumer {
    private static final int PARTITION_COUNT_INITIAL_VALUE = -1;
    private final Map<DynamicFilterId, Integer> buildChannels;
    private final Map<DynamicFilterId, Type> filterBuildTypes;
    private final SettableFuture<TupleDomain<DynamicFilterId>> resultFuture;
    @GuardedBy(value="this")
    private int expectedPartitionCount = -1;
    @GuardedBy(value="this")
    private final List<TupleDomain<DynamicFilterId>> partitions;

    public LocalDynamicFilterConsumer(Map<DynamicFilterId, Integer> buildChannels, Map<DynamicFilterId, Type> filterBuildTypes) {
        this.buildChannels = Objects.requireNonNull(buildChannels, "buildChannels is null");
        this.filterBuildTypes = Objects.requireNonNull(filterBuildTypes, "filterBuildTypes is null");
        Verify.verify((boolean)buildChannels.keySet().equals(filterBuildTypes.keySet()), (String)"filterBuildTypes and buildChannels must have same keys", (Object[])new Object[0]);
        this.resultFuture = SettableFuture.create();
        this.partitions = new ArrayList<TupleDomain<DynamicFilterId>>();
    }

    public ListenableFuture<Map<DynamicFilterId, Domain>> getDynamicFilterDomains() {
        return Futures.transform(this.resultFuture, this::convertTupleDomain, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartition(TupleDomain<DynamicFilterId> tupleDomain) {
        if (this.resultFuture.isDone()) {
            return;
        }
        TupleDomain result = null;
        LocalDynamicFilterConsumer localDynamicFilterConsumer = this;
        synchronized (localDynamicFilterConsumer) {
            Verify.verify((this.expectedPartitionCount == -1 || this.partitions.size() < this.expectedPartitionCount ? 1 : 0) != 0);
            this.partitions.add(tupleDomain);
            if (this.partitions.size() == this.expectedPartitionCount || tupleDomain.isAll()) {
                result = TupleDomain.columnWiseUnion(this.partitions);
            }
        }
        if (result != null) {
            this.resultFuture.set((Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPartitionCount(int partitionCount) {
        TupleDomain result = null;
        LocalDynamicFilterConsumer localDynamicFilterConsumer = this;
        synchronized (localDynamicFilterConsumer) {
            Preconditions.checkState((this.expectedPartitionCount == -1 ? 1 : 0) != 0, (Object)"setPartitionCount should be called only once");
            this.expectedPartitionCount = partitionCount;
            if (this.partitions.size() == this.expectedPartitionCount) {
                result = TupleDomain.columnWiseUnion(this.partitions);
            }
        }
        if (result != null) {
            this.resultFuture.set((Object)result);
        }
    }

    private Map<DynamicFilterId, Domain> convertTupleDomain(TupleDomain<DynamicFilterId> result) {
        if (result.isNone()) {
            return (Map)this.buildChannels.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), filterId -> Domain.none((Type)this.filterBuildTypes.get(filterId))));
        }
        HashMap domains = new HashMap((Map)result.getDomains().get());
        this.buildChannels.keySet().forEach(filterId -> domains.putIfAbsent(filterId, Domain.all((Type)this.filterBuildTypes.get(filterId))));
        return ImmutableMap.copyOf(domains);
    }

    public static LocalDynamicFilterConsumer create(JoinNode planNode, List<Type> buildSourceTypes, Set<DynamicFilterId> collectedFilters) {
        Preconditions.checkArgument((!planNode.getDynamicFilters().isEmpty() ? 1 : 0) != 0, (Object)"Join node dynamicFilters is empty.");
        Preconditions.checkArgument((!collectedFilters.isEmpty() ? 1 : 0) != 0, (Object)"Collected dynamic filters set is empty");
        Preconditions.checkArgument((boolean)planNode.getDynamicFilters().keySet().containsAll(collectedFilters), (Object)"Collected dynamic filters set is not subset of join dynamic filters");
        PlanNode buildNode = planNode.getRight();
        Map buildChannels = (Map)planNode.getDynamicFilters().entrySet().stream().filter(entry -> collectedFilters.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            Symbol buildSymbol = (Symbol)entry.getValue();
            int buildChannelIndex = buildNode.getOutputSymbols().indexOf(buildSymbol);
            Verify.verify((buildChannelIndex >= 0 ? 1 : 0) != 0);
            return buildChannelIndex;
        }));
        Map filterBuildTypes = (Map)buildChannels.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Type)buildSourceTypes.get((Integer)entry.getValue())));
        return new LocalDynamicFilterConsumer(buildChannels, filterBuildTypes);
    }

    public Map<DynamicFilterId, Integer> getBuildChannels() {
        return this.buildChannels;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("buildChannels", this.buildChannels).add("expectedPartitionCount", this.expectedPartitionCount).add("partitions", this.partitions).toString();
    }
}

