/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import io.trino.Session;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.RelationType;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.PlanBuilder;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.RelationPlan;
import io.trino.sql.planner.RelationPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.type.TypeCoercion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final PlannerContext plannerContext;
    private final TypeCoercion typeCoercion;
    private final Session session;
    private final Map<NodeRef<Node>, RelationPlan> recursiveSubqueries;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, PlannerContext plannerContext, TypeCoercion typeCoercion, Optional<TranslationMap> outerContext, Session session, Map<NodeRef<Node>, RelationPlan> recursiveSubqueries) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(typeCoercion, "typeCoercion is null");
        Objects.requireNonNull(outerContext, "outerContext is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(recursiveSubqueries, "recursiveSubqueries is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.plannerContext = plannerContext;
        this.typeCoercion = typeCoercion;
        this.session = session;
        this.recursiveSubqueries = recursiveSubqueries;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Analysis.SubqueryAnalysis subqueries) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, subqueries);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Analysis.SubqueryAnalysis subqueries) {
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, subqueries.getInPredicatesSubqueries()))) {
            builder = this.planInPredicate(builder, cluster, subqueries);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, subqueries.getSubqueries()))) {
            builder = this.planScalarSubquery(builder, cluster);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, subqueries.getExistsSubqueries()))) {
            builder = this.planExists(builder, cluster);
        }
        for (Cluster<InPredicate> cluster : this.cluster(builder.getScope(), this.selectSubqueries(builder, expression, subqueries.getQuantifiedComparisonSubqueries()))) {
            builder = this.planQuantifiedComparison(builder, cluster, subqueries);
        }
        return builder;
    }

    private <T extends Expression> List<T> selectSubqueries(PlanBuilder subPlan, Expression parent, List<T> candidates) {
        SuccessorsFunction recurse = expression -> {
            if (!(expression instanceof Expression) || !this.analysis.isColumnReference((Expression)expression) && !subPlan.canTranslate((Expression)expression)) {
                return expression.getChildren();
            }
            return ImmutableList.of();
        };
        Iterable allSubExpressions = Traverser.forTree((SuccessorsFunction)recurse).depthFirstPreOrder((Object)parent);
        return (List)candidates.stream().filter(candidate -> Streams.stream((Iterable)allSubExpressions).anyMatch(child -> child == candidate)).filter(candidate -> !subPlan.canTranslate((Expression)candidate)).collect(ImmutableList.toImmutableList());
    }

    private <T extends Expression> Collection<Cluster<T>> cluster(Scope scope, List<T> expressions) {
        LinkedHashMap<ScopeAware, List> sets = new LinkedHashMap<ScopeAware, List>();
        for (Expression expression : expressions) {
            sets.computeIfAbsent(ScopeAware.scopeAwareKey(expression, this.analysis, scope), key -> new ArrayList()).add(expression);
        }
        return (Collection)sets.values().stream().map(cluster -> Cluster.newCluster(cluster, scope, this.analysis)).collect(ImmutableList.toImmutableList());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, Cluster<InPredicate> cluster, Analysis.SubqueryAnalysis subqueries) {
        InPredicate predicate = cluster.getRepresentative();
        Expression value = predicate.getValue();
        SubqueryExpression subquery = (SubqueryExpression)predicate.getValueList();
        Symbol output = this.symbolAllocator.newSymbol((Expression)predicate, (Type)BooleanType.BOOLEAN);
        subPlan = this.handleSubqueries(subPlan, value, subqueries);
        subPlan = this.planInPredicate(subPlan, value, subquery, output, (Expression)predicate, this.analysis.getPredicateCoercions((Expression)predicate));
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
    }

    private PlanBuilder planInPredicate(PlanBuilder subPlan, Expression value, SubqueryExpression subquery, Symbol output, Expression originalExpression, Analysis.PredicateCoercions predicateCoercions) {
        QueryPlanner.PlanAndMappings subqueryPlan = this.planSubquery((Expression)subquery, predicateCoercions.getSubqueryCoercion(), subPlan.getTranslations());
        QueryPlanner.PlanAndMappings valuePlan = this.planValue(subPlan, value, predicateCoercions.getValueType(), predicateCoercions.getValueCoercion());
        return new PlanBuilder(valuePlan.getSubPlan().getTranslations(), new ApplyNode(this.idAllocator.getNextId(), valuePlan.getSubPlan().getRoot(), subqueryPlan.getSubPlan().getRoot(), Assignments.of(output, (Expression)new InPredicate((Expression)valuePlan.get(value).toSymbolReference(), (Expression)subqueryPlan.get((Expression)subquery).toSymbolReference())), valuePlan.getSubPlan().getRoot().getOutputSymbols(), (Node)originalExpression));
    }

    private PlanBuilder planScalarSubquery(PlanBuilder subPlan, Cluster<SubqueryExpression> cluster) {
        Symbol column;
        SubqueryExpression scalarSubquery = cluster.getRepresentative();
        RelationPlan relationPlan = this.planSubquery((Expression)scalarSubquery, subPlan.getTranslations());
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, this.session, this.plannerContext);
        PlanNode root = new EnforceSingleRowNode(this.idAllocator.getNextId(), subqueryPlan.getRoot());
        Type type = this.analysis.getType((Expression)scalarSubquery);
        RelationType descriptor = relationPlan.getDescriptor();
        List<Symbol> fieldMappings = relationPlan.getFieldMappings();
        if (descriptor.getVisibleFieldCount() > 1) {
            column = this.symbolAllocator.newSymbol("row", type);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < descriptor.getAllFieldCount(); ++i) {
                Field field = descriptor.getFieldByIndex(i);
                if (field.isHidden()) continue;
                fields.add((Object)fieldMappings.get(i).toSymbolReference());
            }
            Cast expression = new Cast((Expression)new Row((List)fields.build()), TypeSignatureTranslator.toSqlType(type));
            root = new ProjectNode(this.idAllocator.getNextId(), root, Assignments.of(column, (Expression)expression));
        } else {
            column = (Symbol)Iterables.getOnlyElement(fieldMappings);
        }
        return this.appendCorrelatedJoin(subPlan, root, scalarSubquery.getQuery(), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, this.mapAll(cluster, subPlan.getScope(), column));
    }

    public PlanBuilder appendCorrelatedJoin(PlanBuilder subPlan, PlanNode subquery, Query query, CorrelatedJoinNode.Type type, Expression filterCondition, Map<ScopeAware<Expression>, Symbol> mappings) {
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(mappings), new CorrelatedJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), subquery, subPlan.getRoot().getOutputSymbols(), type, filterCondition, (Node)query));
    }

    private PlanBuilder planExists(PlanBuilder subPlan, Cluster<ExistsPredicate> cluster) {
        ExistsPredicate existsPredicate = cluster.getRepresentative();
        Expression subquery = existsPredicate.getSubquery();
        Symbol exists = this.symbolAllocator.newSymbol("exists", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), exists)), new ApplyNode(this.idAllocator.getNextId(), subPlan.getRoot(), this.planSubquery(subquery, subPlan.getTranslations()).getRoot(), Assignments.of(exists, (Expression)new ExistsPredicate((Expression)BooleanLiteral.TRUE_LITERAL)), subPlan.getRoot().getOutputSymbols(), (Node)subquery));
    }

    private RelationPlan planSubquery(Expression subquery, TranslationMap outerContext) {
        return (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.plannerContext, Optional.of(outerContext), this.session, this.recursiveSubqueries).process((Node)subquery, null);
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, Cluster<QuantifiedComparisonExpression> cluster, Analysis.SubqueryAnalysis subqueries) {
        QuantifiedComparisonExpression quantifiedComparison = cluster.getRepresentative();
        ComparisonExpression.Operator operator = quantifiedComparison.getOperator();
        QuantifiedComparisonExpression.Quantifier quantifier = quantifiedComparison.getQuantifier();
        Expression value = quantifiedComparison.getValue();
        SubqueryExpression subquery = (SubqueryExpression)quantifiedComparison.getSubquery();
        subPlan = this.handleSubqueries(subPlan, value, subqueries);
        Symbol output = this.symbolAllocator.newSymbol((Expression)quantifiedComparison, (Type)BooleanType.BOOLEAN);
        Analysis.PredicateCoercions predicateCoercions = this.analysis.getPredicateCoercions((Expression)quantifiedComparison);
        switch (operator) {
            case EQUAL: {
                switch (quantifier) {
                    case ALL: {
                        subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, (Expression)subquery, output, predicateCoercions);
                        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings((Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(quantifiedComparison, this.analysis, subPlan.getScope()), (Object)output)), subPlan.getRoot());
                    }
                    case ANY: 
                    case SOME: {
                        subPlan = this.planInPredicate(subPlan, value, subquery, output, (Expression)quantifiedComparison, predicateCoercions);
                        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (quantifier) {
                    case ALL: {
                        subPlan = this.planInPredicate(subPlan, value, subquery, output, (Expression)quantifiedComparison, predicateCoercions);
                        return this.addNegation(subPlan, cluster, output);
                    }
                    case ANY: 
                    case SOME: {
                        subPlan = this.planQuantifiedComparison(subPlan, ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, value, (Expression)subquery, output, predicateCoercions);
                        return this.addNegation(subPlan, cluster, output);
                    }
                }
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                subPlan = this.planQuantifiedComparison(subPlan, operator, quantifier, value, (Expression)subquery, output, predicateCoercions);
                return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), subPlan.getRoot());
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", operator.getValue(), quantifier));
    }

    private PlanBuilder addNegation(PlanBuilder subPlan, Cluster<? extends Expression> cluster, Symbol input) {
        Symbol output = this.symbolAllocator.newSymbol("not", (Type)BooleanType.BOOLEAN);
        return new PlanBuilder(subPlan.getTranslations().withAdditionalMappings(this.mapAll(cluster, subPlan.getScope(), output)), new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(output, (Expression)new NotExpression((Expression)input.toSymbolReference())).build()));
    }

    private PlanBuilder planQuantifiedComparison(PlanBuilder subPlan, ComparisonExpression.Operator operator, QuantifiedComparisonExpression.Quantifier quantifier, Expression value, Expression subquery, Symbol assignment, Analysis.PredicateCoercions predicateCoercions) {
        QueryPlanner.PlanAndMappings subqueryPlan = this.planSubquery(subquery, predicateCoercions.getSubqueryCoercion(), subPlan.getTranslations());
        QueryPlanner.PlanAndMappings valuePlan = this.planValue(subPlan, value, predicateCoercions.getValueType(), predicateCoercions.getValueCoercion());
        return new PlanBuilder(valuePlan.getSubPlan().getTranslations(), new ApplyNode(this.idAllocator.getNextId(), valuePlan.getSubPlan().getRoot(), subqueryPlan.getSubPlan().getRoot(), Assignments.of(assignment, (Expression)new QuantifiedComparisonExpression(operator, quantifier, (Expression)valuePlan.get(value).toSymbolReference(), (Expression)subqueryPlan.get(subquery).toSymbolReference())), valuePlan.getSubPlan().getRoot().getOutputSymbols(), (Node)subquery));
    }

    private QueryPlanner.PlanAndMappings planValue(PlanBuilder subPlan, Expression value, Type actualType, Optional<Type> coercion) {
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)value), this.symbolAllocator, this.idAllocator);
        Symbol column = subPlan.translate(value);
        Type declaredType = this.analysis.getType(value);
        if (!actualType.equals(declaredType)) {
            Symbol wrapped = this.symbolAllocator.newSymbol("row", actualType);
            Assignments assignments = Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(wrapped, (Expression)new Row((List)ImmutableList.of((Object)column.toSymbolReference()))).build();
            subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments));
            column = wrapped;
        }
        return this.coerceIfNecessary(subPlan, column, value, actualType, coercion);
    }

    private QueryPlanner.PlanAndMappings planSubquery(Expression subquery, Optional<Type> coercion, TranslationMap outerContext) {
        Type type = this.analysis.getType(subquery);
        Symbol column = this.symbolAllocator.newSymbol("row", type);
        RelationPlan relationPlan = this.planSubquery(subquery, outerContext);
        PlanBuilder subqueryPlan = PlanBuilder.newPlanBuilder(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap, (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(ScopeAware.scopeAwareKey(subquery, this.analysis, relationPlan.getScope()), (Object)column), this.session, this.plannerContext);
        RelationType descriptor = relationPlan.getDescriptor();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (int i = 0; i < descriptor.getAllFieldCount(); ++i) {
            Field field = descriptor.getFieldByIndex(i);
            if (field.isHidden()) continue;
            fields.add((Object)relationPlan.getFieldMappings().get(i).toSymbolReference());
        }
        subqueryPlan = subqueryPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), relationPlan.getRoot(), Assignments.of(column, (Expression)new Cast((Expression)new Row((List)fields.build()), TypeSignatureTranslator.toSqlType(type)))));
        return this.coerceIfNecessary(subqueryPlan, column, subquery, this.analysis.getType(subquery), coercion);
    }

    private QueryPlanner.PlanAndMappings coerceIfNecessary(PlanBuilder subPlan, Symbol symbol, Expression value, Type type, Optional<? extends Type> coercion) {
        Symbol coerced = symbol;
        if (coercion.isPresent()) {
            coerced = this.symbolAllocator.newSymbol(value, coercion.get());
            Assignments assignments = Assignments.builder().putIdentities(subPlan.getRoot().getOutputSymbols()).put(coerced, (Expression)new Cast((Expression)symbol.toSymbolReference(), TypeSignatureTranslator.toSqlType(coercion.get()), false, this.typeCoercion.isTypeOnlyCoercion(type, coercion.get()))).build();
            subPlan = subPlan.withNewRoot(new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), assignments));
        }
        return new QueryPlanner.PlanAndMappings(subPlan, (Map<NodeRef<Expression>, Symbol>)ImmutableMap.of((Object)NodeRef.of((Node)value), (Object)coerced));
    }

    private <T extends Expression> Map<ScopeAware<Expression>, Symbol> mapAll(Cluster<T> cluster, Scope scope, Symbol output) {
        return (Map)cluster.getExpressions().stream().collect(ImmutableMap.toImmutableMap(expression -> ScopeAware.scopeAwareKey(expression, this.analysis, scope), expression -> output, (first, second) -> first));
    }

    private static class Cluster<T extends Expression> {
        private final List<T> expressions;

        private Cluster(List<T> expressions) {
            Preconditions.checkArgument((!expressions.isEmpty() ? 1 : 0) != 0, (Object)"Cluster is empty");
            this.expressions = ImmutableList.copyOf(expressions);
        }

        public static <T extends Expression> Cluster<T> newCluster(List<T> expressions, Scope scope, Analysis analysis) {
            long count = expressions.stream().map(expression -> ScopeAware.scopeAwareKey(expression, analysis, scope)).distinct().count();
            Preconditions.checkArgument((count == 1L ? 1 : 0) != 0, (Object)"Cluster contains expressions that are not equivalent to each other");
            return new Cluster<T>(expressions);
        }

        public List<T> getExpressions() {
            return this.expressions;
        }

        public T getRepresentative() {
            return (T)((Expression)this.expressions.get(0));
        }
    }
}

