/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.metadata.TableFunctionHandle;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.NameAndPosition;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableFunctionNode
extends PlanNode {
    private final String name;
    private final Map<String, Argument> arguments;
    private final List<Symbol> properOutputs;
    private final List<PlanNode> sources;
    private final List<TableArgumentProperties> tableArgumentProperties;
    private final Map<NameAndPosition, Symbol> inputDescriptorMappings;
    private final TableFunctionHandle handle;

    @JsonCreator
    public TableFunctionNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="name") String name, @JsonProperty(value="arguments") Map<String, Argument> arguments, @JsonProperty(value="properOutputs") List<Symbol> properOutputs, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="tableArgumentProperties") List<TableArgumentProperties> tableArgumentProperties, @JsonProperty(value="inputDescriptorMappings") Map<NameAndPosition, Symbol> inputDescriptorMappings, @JsonProperty(value="handle") TableFunctionHandle handle) {
        super(id);
        this.name = Objects.requireNonNull(name, "name is null");
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.properOutputs = Objects.requireNonNull(properOutputs, "properOutputs is null");
        this.sources = Objects.requireNonNull(sources, "sources is null");
        this.tableArgumentProperties = Objects.requireNonNull(tableArgumentProperties, "tableArgumentProperties is null");
        this.inputDescriptorMappings = Objects.requireNonNull(inputDescriptorMappings, "inputDescriptorMappings is null");
        this.handle = Objects.requireNonNull(handle, "handle is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Map<String, Argument> getArguments() {
        return this.arguments;
    }

    @JsonProperty
    public List<Symbol> getProperOutputs() {
        return this.properOutputs;
    }

    @JsonProperty
    public List<TableArgumentProperties> getTableArgumentProperties() {
        return this.tableArgumentProperties;
    }

    @JsonProperty
    public Map<NameAndPosition, Symbol> getInputDescriptorMappings() {
        return this.inputDescriptorMappings;
    }

    @JsonProperty
    public TableFunctionHandle getHandle() {
        return this.handle;
    }

    @Override
    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.properOutputs;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunction(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newSources) {
        Preconditions.checkArgument((this.sources.size() == newSources.size() ? 1 : 0) != 0, (Object)"wrong number of new children");
        return new TableFunctionNode(this.getId(), this.name, this.arguments, this.properOutputs, newSources, this.tableArgumentProperties, this.inputDescriptorMappings, this.handle);
    }

    public static class TableArgumentProperties {
        private final boolean rowSemantics;
        private final boolean pruneWhenEmpty;
        private final boolean passThroughColumns;
        private final WindowNode.Specification specification;

        @JsonCreator
        public TableArgumentProperties(@JsonProperty(value="rowSemantics") boolean rowSemantics, @JsonProperty(value="pruneWhenEmpty") boolean pruneWhenEmpty, @JsonProperty(value="passThroughColumns") boolean passThroughColumns, @JsonProperty(value="specification") WindowNode.Specification specification) {
            this.rowSemantics = rowSemantics;
            this.pruneWhenEmpty = pruneWhenEmpty;
            this.passThroughColumns = passThroughColumns;
            this.specification = Objects.requireNonNull(specification, "specification is null");
        }

        @JsonProperty
        public boolean isRowSemantics() {
            return this.rowSemantics;
        }

        @JsonProperty
        public boolean isPruneWhenEmpty() {
            return this.pruneWhenEmpty;
        }

        @JsonProperty
        public boolean isPassThroughColumns() {
            return this.passThroughColumns;
        }

        @JsonProperty
        public WindowNode.Specification getSpecification() {
            return this.specification;
        }
    }
}

