/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import io.airlift.units.Duration;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.planprinter.NodeRepresentation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class PlanRepresentation {
    private final PlanNode root;
    private final TypeProvider types;
    private final Optional<Duration> totalCpuTime;
    private final Optional<Duration> totalScheduledTime;
    private final Optional<Duration> totalBlockedTime;
    private final Map<PlanNodeId, NodeRepresentation> nodeInfo = new HashMap<PlanNodeId, NodeRepresentation>();

    public PlanRepresentation(PlanNode root, TypeProvider types, Optional<Duration> totalCpuTime, Optional<Duration> totalScheduledTime, Optional<Duration> totalBlockedTime) {
        this.root = Objects.requireNonNull(root, "root is null");
        this.types = Objects.requireNonNull(types, "types is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
    }

    public NodeRepresentation getRoot() {
        return this.nodeInfo.get(this.root.getId());
    }

    public TypeProvider getTypes() {
        return this.types;
    }

    public Optional<Duration> getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public Optional<Duration> getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    public Optional<Duration> getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    public Optional<NodeRepresentation> getNode(PlanNodeId id) {
        return Optional.ofNullable(this.nodeInfo.get(id));
    }

    public void addNode(NodeRepresentation node) {
        this.nodeInfo.put(node.getId(), node);
    }
}

