/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.IndexJoinOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DeleteNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RefreshMaterializedViewNode;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SetOperationNode;
import io.trino.sql.planner.plan.SimpleTableExecuteNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.sql.planner.plan.StatisticsWriterNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.UpdateNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.planner.sanity.PlanSanityChecker;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ValidateDependenciesChecker
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        ValidateDependenciesChecker.validate(plan);
    }

    public static void validate(PlanNode plan) {
        plan.accept(new Visitor(), ImmutableSet.of());
    }

    private static void checkDependencies(Collection<Symbol> inputs, Collection<Symbol> required, String message, Object ... parameters) {
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(inputs).containsAll(required), (String)message, (Object[])parameters);
    }

    private static class Visitor
    extends PlanVisitor<Void, Set<Symbol>> {
        private Visitor() {
        }

        @Override
        protected Void visitPlan(PlanNode node, Set<Symbol> boundSymbols) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitAggregation(AggregationNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getGroupingKeys(), "Invalid node. Grouping key symbols (%s) not in source plan output (%s)", new Object[]{node.getGroupingKeys(), node.getSource().getOutputSymbols()});
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                Set<Symbol> dependencies = SymbolsExtractor.extractUnique(aggregation);
                ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Aggregation dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getInputSymbols(), "Invalid node. Grouping symbols (%s) not in source plan output (%s)", node.getInputSymbols(), source.getOutputSymbols());
            return null;
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getDistinctSymbols(), "Invalid node. Mark distinct symbols (%s) not in source plan output (%s)", node.getDistinctSymbols(), source.getOutputSymbols());
            return null;
        }

        @Override
        public Void visitPatternRecognition(PatternRecognitionNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", new Object[]{node.getPartitionBy(), node.getSource().getOutputSymbols()});
            if (node.getOrderingScheme().isPresent()) {
                ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderingScheme().get().getOrderBy(), "Invalid node. Order by symbols (%s) not in source plan output (%s)", new Object[]{node.getOrderingScheme().get().getOrderBy(), node.getSource().getOutputSymbols()});
            }
            node.getCommonBaseFrame().flatMap(WindowNode.Frame::getEndValue).ifPresent(value -> ValidateDependenciesChecker.checkDependencies(inputs, (Collection<Symbol>)ImmutableList.of((Object)value), "Invalid node. Frame end symbol (%s) not in source plan output (%s)", value, node.getSource().getOutputSymbols()));
            for (WindowNode.Function function : node.getWindowFunctions().values()) {
                Set<Symbol> dependencies = SymbolsExtractor.extractUnique(function);
                ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Window function dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            Set measuresSymbols = (Set)node.getMeasures().values().stream().map(PatternRecognitionNode.Measure::getExpressionAndValuePointers).map(LogicalIndexExtractor.ExpressionAndValuePointers::getInputSymbols).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
            ValidateDependenciesChecker.checkDependencies(inputs, measuresSymbols, "Invalid node. Symbols used in measures (%s) not in source plan output (%s)", new Object[]{measuresSymbols, node.getSource().getOutputSymbols()});
            node.getCommonBaseFrame().flatMap(WindowNode.Frame::getEndValue).ifPresent(symbol -> ValidateDependenciesChecker.checkDependencies(inputs, (Collection<Symbol>)ImmutableSet.of((Object)symbol), "Invalid node. Frame offset symbol (%s) not in source plan output (%s)", symbol, node.getSource().getOutputSymbols()));
            Set variableDefinitionsSymbols = (Set)node.getVariableDefinitions().values().stream().map(LogicalIndexExtractor.ExpressionAndValuePointers::getInputSymbols).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
            ValidateDependenciesChecker.checkDependencies(inputs, variableDefinitionsSymbols, "Invalid node. Symbols used in measures (%s) not in source plan output (%s)", new Object[]{variableDefinitionsSymbols, node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitTableFunction(TableFunctionNode node, Set<Symbol> context) {
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", new Object[]{node.getPartitionBy(), node.getSource().getOutputSymbols()});
            if (node.getOrderingScheme().isPresent()) {
                ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderingScheme().get().getOrderBy(), "Invalid node. Order by symbols (%s) not in source plan output (%s)", new Object[]{node.getOrderingScheme().get().getOrderBy(), node.getSource().getOutputSymbols()});
            }
            ImmutableList.Builder bounds = ImmutableList.builder();
            for (WindowNode.Frame frame : node.getFrames()) {
                if (frame.getStartValue().isPresent()) {
                    bounds.add((Object)frame.getStartValue().get());
                }
                if (!frame.getEndValue().isPresent()) continue;
                bounds.add((Object)frame.getEndValue().get());
            }
            ValidateDependenciesChecker.checkDependencies(inputs, (Collection<Symbol>)bounds.build(), "Invalid node. Frame bounds (%s) not in source plan output (%s)", new Object[]{bounds.build(), node.getSource().getOutputSymbols()});
            ImmutableList.Builder symbolsForFrameBoundsComparison = ImmutableList.builder();
            for (WindowNode.Frame frame : node.getFrames()) {
                if (frame.getSortKeyCoercedForFrameStartComparison().isPresent()) {
                    symbolsForFrameBoundsComparison.add((Object)frame.getSortKeyCoercedForFrameStartComparison().get());
                }
                if (!frame.getSortKeyCoercedForFrameEndComparison().isPresent()) continue;
                symbolsForFrameBoundsComparison.add((Object)frame.getSortKeyCoercedForFrameEndComparison().get());
            }
            ValidateDependenciesChecker.checkDependencies(inputs, (Collection<Symbol>)symbolsForFrameBoundsComparison.build(), "Invalid node. Symbols for frame bound comparison (%s) not in source plan output (%s)", new Object[]{symbolsForFrameBoundsComparison.build(), node.getSource().getOutputSymbols()});
            for (WindowNode.Function function : node.getWindowFunctions().values()) {
                Set<Symbol> dependencies = SymbolsExtractor.extractUnique(function);
                ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Window function dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, node.getSource().getOutputSymbols()});
            }
            return null;
        }

        @Override
        public Void visitTopNRanking(TopNRankingNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", new Object[]{node.getPartitionBy(), node.getSource().getOutputSymbols()});
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderingScheme().getOrderBy(), "Invalid node. Order by symbols (%s) not in source plan output (%s)", new Object[]{node.getOrderingScheme().getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getPartitionBy(), "Invalid node. Partition by symbols (%s) not in source plan output (%s)", node.getPartitionBy(), node.getSource().getOutputSymbols());
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOutputSymbols(), "Invalid node. Output symbols (%s) not in source plan output (%s)", new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            Set<Symbol> dependencies = SymbolsExtractor.extractUnique(node.getPredicate());
            ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Predicate dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitSample(SampleNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            for (Expression expression : node.getAssignments().getExpressions()) {
                Set<Symbol> dependencies = SymbolsExtractor.extractUnique(expression);
                ValidateDependenciesChecker.checkDependencies(inputs, dependencies, "Invalid node. Expression dependencies (%s) not in source plan output (%s)", new Object[]{dependencies, inputs});
            }
            return null;
        }

        @Override
        public Void visitTopN(TopNNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOutputSymbols(), "Invalid node. Output symbols (%s) not in source plan output (%s)", new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderingScheme().getOrderBy(), "Invalid node. Order by dependencies (%s) not in source plan output (%s)", new Object[]{node.getOrderingScheme().getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitSort(SortNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet<Symbol> inputs = Visitor.createInputs(source, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOutputSymbols(), "Invalid node. Output symbols (%s) not in source plan output (%s)", new Object[]{node.getOutputSymbols(), node.getSource().getOutputSymbols()});
            ValidateDependenciesChecker.checkDependencies(inputs, node.getOrderingScheme().getOrderBy(), "Invalid node. Order by dependencies (%s) not in source plan output (%s)", new Object[]{node.getOrderingScheme().getOrderBy(), node.getSource().getOutputSymbols()});
            return null;
        }

        @Override
        public Void visitOutput(OutputNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getOutputSymbols(), "Invalid node. Output column dependencies (%s) not in source plan output (%s)", node.getOutputSymbols(), source.getOutputSymbols());
            return null;
        }

        @Override
        public Void visitOffset(OffsetNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            if (node.getTiesResolvingScheme().isPresent()) {
                ValidateDependenciesChecker.checkDependencies(Visitor.createInputs(source, boundSymbols), node.getTiesResolvingScheme().get().getOrderBy(), "Invalid node. Ties resolving dependencies (%s) not in source plan output (%s)", new Object[]{node.getTiesResolvingScheme().get().getOrderBy(), node.getSource().getOutputSymbols()});
            }
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getPreSortedInputs(), "Invalid node. Pre-sorted input column dependencies (%s) not in source plan output (%s)", node.getPreSortedInputs(), source.getOutputSymbols());
            return null;
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), node.getOutputSymbols(), "Invalid node. Output column dependencies (%s) not in source plan output (%s)", node.getOutputSymbols(), source.getOutputSymbols());
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Set<Symbol> boundSymbols) {
            node.getLeft().accept(this, boundSymbols);
            node.getRight().accept(this, boundSymbols);
            ImmutableSet<Symbol> leftInputs = Visitor.createInputs(node.getLeft(), boundSymbols);
            ImmutableSet<Symbol> rightInputs = Visitor.createInputs(node.getRight(), boundSymbols);
            ImmutableSet allInputs = ImmutableSet.builder().addAll(leftInputs).addAll(rightInputs).build();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                Preconditions.checkArgument((boolean)leftInputs.contains(clause.getLeft()), (String)"Symbol from join clause (%s) not in left source (%s)", (Object)clause.getLeft(), node.getLeft().getOutputSymbols());
                Preconditions.checkArgument((boolean)rightInputs.contains(clause.getRight()), (String)"Symbol from join clause (%s) not in right source (%s)", (Object)clause.getRight(), node.getRight().getOutputSymbols());
            }
            node.getFilter().ifPresent(arg_0 -> Visitor.lambda$visitJoin$2((Set)allInputs, arg_0));
            if (node.isCrossJoin()) {
                ImmutableSet inputs = ImmutableSet.builder().addAll(node.getLeft().getOutputSymbols()).addAll(node.getRight().getOutputSymbols()).build();
                ValidateDependenciesChecker.checkDependencies(node.getOutputSymbols(), (Collection<Symbol>)inputs, "Cross join output symbols (%s) must contain all of the source symbols (%s)", node.getOutputSymbols(), inputs);
            }
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            node.getFilteringSource().accept(this, boundSymbols);
            Preconditions.checkArgument((boolean)node.getSource().getOutputSymbols().contains(node.getSourceJoinSymbol()), (String)"Symbol from semi join clause (%s) not in source (%s)", (Object)node.getSourceJoinSymbol(), node.getSource().getOutputSymbols());
            Preconditions.checkArgument((boolean)node.getFilteringSource().getOutputSymbols().contains(node.getFilteringSourceJoinSymbol()), (String)"Symbol from semi join clause (%s) not in filtering source (%s)", (Object)node.getSourceJoinSymbol(), node.getFilteringSource().getOutputSymbols());
            ImmutableSet<Symbol> outputs = Visitor.createInputs(node, boundSymbols);
            Preconditions.checkArgument((boolean)outputs.containsAll(node.getSource().getOutputSymbols()), (String)"Semi join output symbols (%s) must contain all of the source symbols (%s)", node.getOutputSymbols(), node.getSource().getOutputSymbols());
            Preconditions.checkArgument((boolean)outputs.contains(node.getSemiJoinOutput()), (String)"Semi join output symbols (%s) must contain join result (%s)", node.getOutputSymbols(), (Object)node.getSemiJoinOutput());
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Set<Symbol> boundSymbols) {
            node.getLeft().accept(this, boundSymbols);
            node.getRight().accept(this, boundSymbols);
            ImmutableSet<Symbol> leftInputs = Visitor.createInputs(node.getLeft(), boundSymbols);
            ImmutableSet<Symbol> rightInputs = Visitor.createInputs(node.getRight(), boundSymbols);
            ImmutableSet allInputs = ImmutableSet.builder().addAll(leftInputs).addAll(rightInputs).build();
            Set<Symbol> predicateSymbols = SymbolsExtractor.extractUnique(node.getFilter());
            Preconditions.checkArgument((boolean)allInputs.containsAll(predicateSymbols), (String)"Symbol from filter (%s) not in sources (%s)", predicateSymbols, (Object)allInputs);
            this.checkLeftOutputSymbolsBeforeRight(node.getLeft().getOutputSymbols(), node.getOutputSymbols());
            return null;
        }

        private void checkLeftOutputSymbolsBeforeRight(List<Symbol> leftSymbols, List<Symbol> outputSymbols) {
            int leftMaxPosition = -1;
            Optional<Object> rightMinPosition = Optional.empty();
            HashSet<Symbol> leftSymbolsSet = new HashSet<Symbol>(leftSymbols);
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                if (leftSymbolsSet.contains(symbol)) {
                    leftMaxPosition = i;
                    continue;
                }
                if (!rightMinPosition.isEmpty()) continue;
                rightMinPosition = Optional.of(i);
            }
            Preconditions.checkState((rightMinPosition.isEmpty() || (Integer)rightMinPosition.get() > leftMaxPosition ? 1 : 0) != 0, (Object)"Not all left output symbols are before right output symbols");
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Set<Symbol> boundSymbols) {
            node.getProbeSource().accept(this, boundSymbols);
            node.getIndexSource().accept(this, boundSymbols);
            ImmutableSet<Symbol> probeInputs = Visitor.createInputs(node.getProbeSource(), boundSymbols);
            ImmutableSet<Symbol> indexSourceInputs = Visitor.createInputs(node.getIndexSource(), boundSymbols);
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                Preconditions.checkArgument((boolean)probeInputs.contains(clause.getProbe()), (String)"Probe symbol from index join clause (%s) not in probe source (%s)", (Object)clause.getProbe(), node.getProbeSource().getOutputSymbols());
                Preconditions.checkArgument((boolean)indexSourceInputs.contains(clause.getIndex()), (String)"Index symbol from index join clause (%s) not in index source (%s)", (Object)clause.getIndex(), node.getIndexSource().getOutputSymbols());
            }
            Set lookupSymbols = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableSet.toImmutableSet());
            Map<Symbol, Symbol> trace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), lookupSymbols);
            Preconditions.checkArgument((!trace.isEmpty() ? 1 : 0) != 0, (String)"Index lookup symbols are not traceable to index source: %s", (Object)lookupSymbols);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Set<Symbol> boundSymbols) {
            ValidateDependenciesChecker.checkDependencies(node.getOutputSymbols(), node.getLookupSymbols(), "Lookup symbols must be part of output symbols", new Object[0]);
            ValidateDependenciesChecker.checkDependencies(node.getAssignments().keySet(), node.getOutputSymbols(), "Assignments must contain mappings for output symbols", new Object[0]);
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Set<Symbol> boundSymbols) {
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Set<Symbol> boundSymbols) {
            Set<Symbol> correlatedDependencies = SymbolsExtractor.extractUnique(node);
            ValidateDependenciesChecker.checkDependencies(boundSymbols, correlatedDependencies, "Invalid node. Expression correlated dependencies (%s) not satisfied by (%s)", correlatedDependencies, boundSymbols);
            return null;
        }

        @Override
        public Void visitUnnest(UnnestNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            ImmutableSet.Builder required = ImmutableSet.builder().addAll(node.getReplicateSymbols());
            node.getMappings().stream().map(UnnestNode.Mapping::getInput).forEach(arg_0 -> ((ImmutableSet.Builder)required).add(arg_0));
            Set unnestedSymbols = (Set)node.getMappings().stream().map(UnnestNode.Mapping::getOutputs).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
            Sets.SetView expectedFilterSymbols = Sets.difference(SymbolsExtractor.extractUnique(node.getFilter().orElse((Expression)BooleanLiteral.TRUE_LITERAL)), (Set)unnestedSymbols);
            required.addAll((Iterable)expectedFilterSymbols);
            ValidateDependenciesChecker.checkDependencies(source.getOutputSymbols(), (Collection<Symbol>)required.build(), "Invalid node. Dependencies (%s) not in source plan output (%s)", required, source.getOutputSymbols());
            return null;
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Set<Symbol> boundSymbols) {
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Set<Symbol> boundSymbols) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                ValidateDependenciesChecker.checkDependencies(subplan.getOutputSymbols(), (Collection<Symbol>)node.getInputs().get(i), "EXCHANGE subplan must provide all of the necessary symbols", new Object[0]);
                subplan.accept(this, boundSymbols);
            }
            ValidateDependenciesChecker.checkDependencies(node.getOutputSymbols(), node.getPartitioningScheme().getOutputLayout(), "EXCHANGE must provide all of the necessary symbols for partition function", new Object[0]);
            return null;
        }

        @Override
        public Void visitRefreshMaterializedView(RefreshMaterializedViewNode node, Set<Symbol> boundSymbols) {
            return null;
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitDelete(DeleteNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(node.getRowId()), (String)"Invalid node. Row ID symbol (%s) is not in source plan output (%s)", (Object)node.getRowId(), node.getSource().getOutputSymbols());
            return null;
        }

        @Override
        public Void visitUpdate(UpdateNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(node.getRowId()), (String)"Invalid node. Row ID symbol (%s) is not in source plan output (%s)", (Object)node.getRowId(), node.getSource().getOutputSymbols());
            Preconditions.checkArgument((boolean)source.getOutputSymbols().containsAll(node.getColumnValueAndRowIdSymbols()), (String)"Invalid node. Some UPDATE SET expression symbols (%s) are not contained in the outputSymbols (%s)", node.getColumnValueAndRowIdSymbols(), source.getOutputSymbols());
            return null;
        }

        @Override
        public Void visitTableExecute(TableExecuteNode node, Set<Symbol> boundSymbols) {
            PlanNode source = node.getSource();
            source.accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitSimpleTableExecuteNode(SimpleTableExecuteNode node, Set<Symbol> context) {
            return null;
        }

        @Override
        public Void visitTableDelete(TableDeleteNode node, Set<Symbol> boundSymbols) {
            return null;
        }

        @Override
        public Void visitStatisticsWriterNode(StatisticsWriterNode node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            StatisticAggregationsDescriptor<Symbol> descriptor = node.getDescriptor();
            ImmutableSet dependencies = ImmutableSet.builder().addAll(descriptor.getGrouping().values()).addAll(descriptor.getColumnStatistics().values()).addAll(descriptor.getTableStatistics().values()).build();
            List<Symbol> outputSymbols = node.getSource().getOutputSymbols();
            ValidateDependenciesChecker.checkDependencies(outputSymbols, (Collection<Symbol>)dependencies, "Invalid node. Dependencies (%s) not in source plan output (%s)", dependencies, outputSymbols);
            return null;
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Set<Symbol> boundSymbols) {
            return this.visitSetOperation(node, boundSymbols);
        }

        private Void visitSetOperation(SetOperationNode node, Set<Symbol> boundSymbols) {
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                ValidateDependenciesChecker.checkDependencies(subplan.getOutputSymbols(), node.sourceOutputLayout(i), "%s subplan must provide all of the necessary symbols", node.getClass().getSimpleName());
                subplan.accept(this, boundSymbols);
            }
            return null;
        }

        @Override
        public Void visitIntersect(IntersectNode node, Set<Symbol> boundSymbols) {
            return this.visitSetOperation(node, boundSymbols);
        }

        @Override
        public Void visitExcept(ExceptNode node, Set<Symbol> boundSymbols) {
            return this.visitSetOperation(node, boundSymbols);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Set<Symbol> boundSymbols) {
            node.getSource().accept(this, boundSymbols);
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Set<Symbol> boundSymbols) {
            ImmutableSet subqueryCorrelation = ImmutableSet.builder().addAll(boundSymbols).addAll(node.getCorrelation()).build();
            node.getInput().accept(this, boundSymbols);
            node.getSubquery().accept(this, subqueryCorrelation);
            ValidateDependenciesChecker.checkDependencies(node.getInput().getOutputSymbols(), node.getCorrelation(), "APPLY input must provide all the necessary correlation symbols for subquery", new Object[0]);
            ImmutableSet inputs = ImmutableSet.builder().addAll(Visitor.createInputs(node.getSubquery(), boundSymbols)).addAll(Visitor.createInputs(node.getInput(), boundSymbols)).build();
            for (Expression expression : node.getSubqueryAssignments().getExpressions()) {
                Set<Symbol> dependencies = SymbolsExtractor.extractUnique(expression);
                ValidateDependenciesChecker.checkDependencies((Collection<Symbol>)inputs, dependencies, "Invalid node. Expression dependencies (%s) not in source plan output (%s)", dependencies, inputs);
            }
            return null;
        }

        @Override
        public Void visitCorrelatedJoin(CorrelatedJoinNode node, Set<Symbol> boundSymbols) {
            ImmutableSet subqueryCorrelation = ImmutableSet.builder().addAll(boundSymbols).addAll(node.getCorrelation()).build();
            node.getInput().accept(this, boundSymbols);
            node.getSubquery().accept(this, subqueryCorrelation);
            ValidateDependenciesChecker.checkDependencies(node.getInput().getOutputSymbols(), node.getCorrelation(), "Correlated JOIN input must provide all the necessary correlation symbols for subquery", new Object[0]);
            ImmutableSet inputs = ImmutableSet.builder().addAll(Visitor.createInputs(node.getInput(), boundSymbols)).addAll(Visitor.createInputs(node.getSubquery(), boundSymbols)).build();
            Set<Symbol> filterSymbols = SymbolsExtractor.extractUnique(node.getFilter());
            ValidateDependenciesChecker.checkDependencies((Collection<Symbol>)inputs, filterSymbols, "filter symbols (%s) not in sources (%s)", filterSymbols, inputs);
            return null;
        }

        private static ImmutableSet<Symbol> createInputs(PlanNode source, Set<Symbol> boundSymbols) {
            return ImmutableSet.builder().addAll(source.getOutputSymbols()).addAll(boundSymbols).build();
        }

        private static /* synthetic */ void lambda$visitJoin$2(Set allInputs, Expression predicate) {
            Set<Symbol> predicateSymbols = SymbolsExtractor.extractUnique(predicate);
            Preconditions.checkArgument((boolean)allInputs.containsAll(predicateSymbols), (String)"Symbol from filter (%s) not in sources (%s)", predicateSymbols, (Object)allInputs);
        }
    }
}

