/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockBuilder {
    @Test
    public void testMultipleValuesWithNull() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 10);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        Block block = blockBuilder.build();
        Assert.assertTrue((boolean)block.isNull(0));
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 1), (long)42L);
        Assert.assertTrue((boolean)block.isNull(2));
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 3), (long)42L);
    }

    @Test
    public void testNewBlockBuilderLike() {
        ArrayType longArrayType = new ArrayType((Type)BigintType.BIGINT);
        ArrayType arrayType = new ArrayType((Type)longArrayType);
        ImmutableList channels = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)arrayType);
        PageBuilder pageBuilder = new PageBuilder((List)channels);
        BlockBuilder bigintBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder varcharBlockBuilder = pageBuilder.getBlockBuilder(1);
        BlockBuilder arrayBlockBuilder = pageBuilder.getBlockBuilder(2);
        for (int i = 0; i < 100; ++i) {
            BigintType.BIGINT.writeLong(bigintBlockBuilder, (long)i);
            VarcharType.VARCHAR.writeSlice(varcharBlockBuilder, Slices.utf8Slice((String)("test" + i)));
            BlockBuilder blockBuilder = longArrayType.createBlockBuilder(null, 1);
            longArrayType.writeObject(blockBuilder, (Object)BigintType.BIGINT.createBlockBuilder(null, 2).writeLong((long)i).writeLong((long)(i * 2)).build());
            arrayType.writeObject(arrayBlockBuilder, (Object)blockBuilder);
            pageBuilder.declarePosition();
        }
        PageBuilder newPageBuilder = pageBuilder.newPageBuilderLike();
        for (int i = 0; i < channels.size(); ++i) {
            Assert.assertEquals((Object)newPageBuilder.getType(i), (Object)pageBuilder.getType(i));
            Assert.assertNotEquals((Object)pageBuilder.getBlockBuilder(i), (Object)newPageBuilder.getBlockBuilder(i));
            Assert.assertEquals((int)newPageBuilder.getBlockBuilder(i).getPositionCount(), (int)0);
            Assert.assertTrue((newPageBuilder.getBlockBuilder(i).getRetainedSizeInBytes() < pageBuilder.getBlockBuilder(i).getRetainedSizeInBytes() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetPositions() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(5).appendNull().writeLong(42L).appendNull().writeLong(43L).appendNull();
        int[] positions = new int[]{0, 1, 1, 1, 4};
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 0, positions.length), BigintType.BIGINT.createFixedSizeBlockBuilder(5).appendNull().writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 1, 4), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 2, 1), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 0, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 1, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{-1}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, 1, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, -1, 1);
        TestBlockBuilder.assertInvalidGetPositions((Block)blockBuilder, new int[]{6}, 2, -1);
        Block block = blockBuilder.build();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, positions.length), BigintType.BIGINT.createFixedSizeBlockBuilder(5).appendNull().writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 4), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).writeLong(42L).writeLong(42L).appendNull().build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 2, 1), BigintType.BIGINT.createFixedSizeBlockBuilder(5).writeLong(42L).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 0), BigintType.BIGINT.createFixedSizeBlockBuilder(5).build());
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{-1}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, 0, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, 1, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, -1, 1);
        TestBlockBuilder.assertInvalidGetPositions(block, new int[]{6}, 2, -1);
        AtomicBoolean isIdentical = new AtomicBoolean(false);
        block.getPositions(positions, 0, positions.length - 1).retainedBytesForEachPart((part, size) -> {
            if (part == positions) {
                isIdentical.set(true);
            }
        });
        Assert.assertTrue((boolean)isIdentical.get());
    }

    private static void assertInvalidGetPositions(Block block, int[] positions, int offset, int length) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> block.getPositions(positions, offset, length).getLong(0, 0)).isInstanceOfAny(new Class[]{IllegalArgumentException.class, IndexOutOfBoundsException.class})).hasMessageMatching(String.format("(position is not valid|Invalid offset %d and length %d in array with %d elements)", offset, length, positions.length));
    }
}

