/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.block.BlockAssertions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.block.SingleMapBlockWriter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.StructuralTestUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMapBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        this.testWith(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock compactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock inCompactKeyBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        ByteArrayBlock inCompactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestMapBlock.createExpectedValue(17).getBytes());
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] mapIsNull = new boolean[]{false, true, false, false, false, false};
        TestMapBlock.testCompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(Optional.empty(), new int[1], (Block)emptyBlock, (Block)emptyBlock));
        TestMapBlock.testCompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(Optional.of(mapIsNull), offsets, (Block)compactKeyBlock, (Block)compactValueBlock));
        TestMapBlock.testIncompactBlock(StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT).createBlockFromKeyValue(Optional.of(mapIsNull), offsets, (Block)inCompactKeyBlock, (Block)inCompactValueBlock));
    }

    @Test
    public void testLazyHashTableBuildOverBlockRegion() {
        this.assertLazyHashTableBuildOverBlockRegion(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
        this.assertLazyHashTableBuildOverBlockRegion(TestMapBlock.alternatingNullValues(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5)));
    }

    private void assertLazyHashTableBuildOverBlockRegion(Map<String, Long>[] testValues) {
        this.testLazyGetPositionsHashTable(testValues);
        this.testLazyBeginningGetRegionHashTable(testValues);
        this.testLazyMiddleGetRegionHashTable(testValues);
        this.testLazyEndGetRegionHashTable(testValues);
    }

    private void testLazyGetPositionsHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(testValues);
        int[] testPositions = new int[]{7, 1, 5, 2, 3, 7};
        Block prefix = block.getPositions(testPositions, 0, testPositions.length);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        this.assertBlock(prefix, () -> blockBuilder.newBlockBuilderLike(null), TestMapBlock.getArrayPositions(testValues, testPositions));
        Assert.assertTrue((boolean)block.isHashTablesPresent());
    }

    private static Map<String, Long>[] getArrayPositions(Map<String, Long>[] testPositions, int[] positions) {
        Map[] values = new Map[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            values[i] = testPositions[positions[i]];
        }
        return values;
    }

    private void testLazyBeginningGetRegionHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(testValues);
        MapBlock prefix = (MapBlock)block.getRegion(0, 4);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        Assert.assertFalse((boolean)prefix.isHashTablesPresent());
        this.assertBlock((Block)prefix, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 0, 4));
        Assert.assertTrue((boolean)block.isHashTablesPresent());
        Assert.assertTrue((boolean)prefix.isHashTablesPresent());
        MapBlock midSection = (MapBlock)block.getRegion(2, 4);
        Assert.assertTrue((boolean)midSection.isHashTablesPresent());
        this.assertBlock((Block)midSection, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 2, 6));
        MapBlock suffix = (MapBlock)block.getRegion(4, 4);
        Assert.assertTrue((boolean)suffix.isHashTablesPresent());
        this.assertBlock((Block)suffix, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 4, 8));
    }

    private void testLazyMiddleGetRegionHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(testValues);
        MapBlock midSection = (MapBlock)block.getRegion(2, 4);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        Assert.assertFalse((boolean)midSection.isHashTablesPresent());
        this.assertBlock((Block)midSection, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 2, 6));
        Assert.assertTrue((boolean)block.isHashTablesPresent());
        Assert.assertTrue((boolean)midSection.isHashTablesPresent());
        MapBlock prefix = (MapBlock)block.getRegion(0, 4);
        Assert.assertTrue((boolean)prefix.isHashTablesPresent());
        this.assertBlock((Block)prefix, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 0, 4));
        MapBlock suffix = (MapBlock)block.getRegion(4, 4);
        Assert.assertTrue((boolean)suffix.isHashTablesPresent());
        this.assertBlock((Block)suffix, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 4, 8));
    }

    private void testLazyEndGetRegionHashTable(Map<String, Long>[] testValues) {
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(testValues);
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(testValues);
        MapBlock suffix = (MapBlock)block.getRegion(4, 4);
        Assert.assertFalse((boolean)block.isHashTablesPresent());
        Assert.assertFalse((boolean)suffix.isHashTablesPresent());
        this.assertBlock((Block)suffix, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 4, 8));
        Assert.assertTrue((boolean)block.isHashTablesPresent());
        Assert.assertTrue((boolean)suffix.isHashTablesPresent());
        MapBlock prefix = (MapBlock)block.getRegion(0, 4);
        Assert.assertTrue((boolean)prefix.isHashTablesPresent());
        this.assertBlock((Block)prefix, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 0, 4));
        MapBlock midSection = (MapBlock)block.getRegion(2, 4);
        Assert.assertTrue((boolean)midSection.isHashTablesPresent());
        this.assertBlock((Block)midSection, () -> blockBuilder.newBlockBuilderLike(null), Arrays.copyOfRange(testValues, 2, 6));
    }

    private static Map<String, Long>[] createTestMap(int ... entryCounts) {
        Map[] result = new Map[entryCounts.length];
        for (int rowNumber = 0; rowNumber < entryCounts.length; ++rowNumber) {
            int entryCount = entryCounts[rowNumber];
            HashMap<CallSite, Long> map = new HashMap<CallSite, Long>();
            for (int entryNumber = 0; entryNumber < entryCount; ++entryNumber) {
                map.put((CallSite)((Object)("key" + entryNumber)), entryNumber == 5 ? null : Long.valueOf((long)rowNumber * 100L + (long)entryNumber));
            }
            result[rowNumber] = map;
        }
        return result;
    }

    private void testWith(Map<String, Long>[] expectedValues) {
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, (Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        MapBlock block = this.createBlockWithValuesFromKeyValueBlock(expectedValues);
        this.assertBlock((Block)block, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlockFilteredPositions(expectedValues, (Block)block, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions(expectedValues, (Block)block, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 5, 6);
        Map<String, Long>[] expectedValuesWithNull = TestMapBlock.alternatingNullValues(expectedValues);
        BlockBuilder blockBuilderWithNull = this.createBlockBuilderWithValues(expectedValuesWithNull);
        this.assertBlock((Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlock(blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockBuilderWithNull, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
        this.assertBlockFilteredPositions(expectedValuesWithNull, blockBuilderWithNull.build(), () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
        MapBlock blockWithNull = this.createBlockWithValuesFromKeyValueBlock(expectedValuesWithNull);
        this.assertBlock((Block)blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), expectedValuesWithNull);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions(expectedValuesWithNull, (Block)blockWithNull, () -> blockBuilder.newBlockBuilderLike(null), 2, 3, 4, 9, 13, 14);
    }

    private BlockBuilder createBlockBuilderWithValues(Map<String, Long>[] maps) {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
        for (Map<String, Long> map : maps) {
            this.createBlockBuilderWithValues(map, mapBlockBuilder);
        }
        return mapBlockBuilder;
    }

    private MapBlock createBlockWithValuesFromKeyValueBlock(Map<String, Long>[] maps) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Long> values = new ArrayList<Long>();
        int[] offsets = new int[maps.length + 1];
        boolean[] mapIsNull = new boolean[maps.length];
        for (int i = 0; i < maps.length; ++i) {
            Map<String, Long> map = maps[i];
            boolean bl = mapIsNull[i] = map == null;
            if (map == null) {
                offsets[i + 1] = offsets[i];
                continue;
            }
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                keys.add(entry.getKey());
                values.add(entry.getValue());
            }
            offsets[i + 1] = offsets[i] + map.size();
        }
        return (MapBlock)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT).createBlockFromKeyValue(Optional.of(mapIsNull), offsets, BlockAssertions.createStringsBlock(keys), BlockAssertions.createLongsBlock(values));
    }

    private void createBlockBuilderWithValues(Map<String, Long> map, BlockBuilder mapBlockBuilder) {
        if (map == null) {
            mapBlockBuilder.appendNull();
        } else {
            BlockBuilder elementBlockBuilder = mapBlockBuilder.beginBlockEntry();
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                VarcharType.VARCHAR.writeSlice(elementBlockBuilder, Slices.utf8Slice((String)entry.getKey()));
                if (entry.getValue() == null) {
                    elementBlockBuilder.appendNull();
                    continue;
                }
                BigintType.BIGINT.writeLong(elementBlockBuilder, entry.getValue().longValue());
            }
            mapBlockBuilder.closeEntry();
        }
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue instanceof Map) {
            this.assertValue(block, position, (Map)expectedValue);
            return;
        }
        super.assertPositionValue(block, position, expectedValue);
    }

    private void assertValue(Block mapBlock, int position, Map<String, Long> map) {
        int i;
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        Objects.requireNonNull(map, "map is null");
        Assert.assertFalse((boolean)mapBlock.isNull(position));
        SingleMapBlock elementBlock = (SingleMapBlock)mapType.getObject(mapBlock, position);
        Assert.assertEquals((int)elementBlock.getPositionCount(), (int)(map.size() * 2));
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            int pos = elementBlock.seekKey((Object)Slices.utf8Slice((String)entry.getKey()));
            Assert.assertNotEquals((Object)pos, (Object)-1);
            if (entry.getValue() == null) {
                Assert.assertTrue((boolean)elementBlock.isNull(pos));
                continue;
            }
            Assert.assertFalse((boolean)elementBlock.isNull(pos));
            Assert.assertEquals((long)BigintType.BIGINT.getLong((Block)elementBlock, pos), (long)entry.getValue());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((int)elementBlock.seekKey((Object)Slices.utf8Slice((String)("not-inserted-" + i))), (int)-1);
        }
        for (i = 0; i < elementBlock.getPositionCount(); i += 2) {
            String actualKey = VarcharType.VARCHAR.getSlice((Block)elementBlock, i).toStringUtf8();
            Long actualValue = elementBlock.isNull(i + 1) ? null : Long.valueOf(BigintType.BIGINT.getLong((Block)elementBlock, i + 1));
            Assert.assertTrue((boolean)map.containsKey(actualKey));
            Assert.assertEquals((Object)actualValue, (Object)map.get(actualKey));
        }
    }

    @Test
    public void testStrict() {
        int i;
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 1);
        mapBlockBuilder.strict();
        for (int i2 = 0; i2 < 100; ++i2) {
            SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, 1L);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
            mapBlockBuilder.closeEntry();
        }
        SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
        for (i = 0; i < 50; ++i) {
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)i);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
        }
        mapBlockBuilder.closeEntry();
        entryBuilder = mapBlockBuilder.beginBlockEntry();
        for (i = 0; i < 2; ++i) {
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, 99L);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((MapBlockBuilder)mapBlockBuilder).closeEntry()).isInstanceOf(DuplicateMapKeyException.class)).hasMessage("Duplicate map keys are not allowed");
    }

    @Test
    public void testCloseEntryStrict() throws Exception {
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        MapBlockBuilder mapBlockBuilder = (MapBlockBuilder)mapType.createBlockBuilder(null, 1);
        for (int i = 0; i < 100; ++i) {
            SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, 1L);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
            mapBlockBuilder.closeEntry();
        }
        SingleMapBlockWriter entryBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < 50; ++i) {
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, (long)i);
            BigintType.BIGINT.writeLong((BlockBuilder)entryBuilder, -1L);
        }
        mapBlockBuilder.closeEntryStrict();
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Map<String, Long>[] expectedValues = TestMapBlock.alternatingNullValues(TestMapBlock.createTestMap(9, 3, 4, 0, 8, 0, 6, 5));
        BlockBuilder blockBuilder = this.createBlockBuilderWithValues(expectedValues);
        Block block = blockBuilder.build();
        Assert.assertEquals((int)block.getPositionCount(), (int)expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = TestMapBlock.getExpectedEstimatedDataSize(expectedValues[i]);
            Assert.assertEquals((long)blockBuilder.getEstimatedDataSizeForStats(i), (long)expectedSize);
            Assert.assertEquals((long)block.getEstimatedDataSizeForStats(i), (long)expectedSize);
        }
    }

    private static int getExpectedEstimatedDataSize(Map<String, Long> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            size += entry.getKey().length();
            size += entry.getValue() == null ? 0 : 8;
        }
        return size;
    }
}

