/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.SingleRowBlockWriter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSingleRowBlockWriter {
    private RowBlockBuilder rowBlockBuilder;

    @BeforeClass
    public void setup() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN);
        this.rowBlockBuilder = (RowBlockBuilder)RowType.anonymous((List)types).createBlockBuilder(null, 8);
    }

    @Test
    public void testGetSizeInBytes() {
        SingleRowBlockWriter singleRowBlockWriter = this.rowBlockBuilder.beginBlockEntry();
        Assert.assertEquals((long)0L, (long)singleRowBlockWriter.getSizeInBytes());
        singleRowBlockWriter.writeLong(10L).closeEntry();
        Assert.assertEquals((long)9L, (long)singleRowBlockWriter.getSizeInBytes());
        singleRowBlockWriter.writeByte(10).closeEntry();
        Assert.assertEquals((long)11L, (long)singleRowBlockWriter.getSizeInBytes());
        this.rowBlockBuilder.closeEntry();
        singleRowBlockWriter = this.rowBlockBuilder.beginBlockEntry();
        Assert.assertEquals((long)0L, (long)singleRowBlockWriter.getSizeInBytes());
        singleRowBlockWriter.writeLong(10L).closeEntry();
        Assert.assertEquals((long)9L, (long)singleRowBlockWriter.getSizeInBytes());
        singleRowBlockWriter.writeByte(10).closeEntry();
        Assert.assertEquals((long)11L, (long)singleRowBlockWriter.getSizeInBytes());
        this.rowBlockBuilder.closeEntry();
    }
}

