/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.ptf.AbstractConnectorTableFunction;
import io.trino.spi.ptf.Argument;
import io.trino.spi.ptf.ConnectorTableFunctionHandle;
import io.trino.spi.ptf.Descriptor;
import io.trino.spi.ptf.ReturnTypeSpecification;
import io.trino.spi.ptf.ScalarArgument;
import io.trino.spi.ptf.ScalarArgumentSpecification;
import io.trino.spi.ptf.TableFunctionAnalysis;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TestingTableFunctions {

    public static class SimpleTableFunction
    extends AbstractConnectorTableFunction {
        private static final String SCHEMA_NAME = "system";
        private static final String FUNCTION_NAME = "simple_table_function";
        private static final String TABLE_NAME = "simple_table";

        public SimpleTableFunction() {
            super(SCHEMA_NAME, FUNCTION_NAME, List.of(ScalarArgumentSpecification.builder().name("COLUMN").type((Type)VarcharType.VARCHAR).defaultValue((Object)Slices.utf8Slice((String)"col")).build(), ScalarArgumentSpecification.builder().name("IGNORED").type((Type)BigintType.BIGINT).defaultValue((Object)0L).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments) {
            ScalarArgument argument = (ScalarArgument)arguments.get("COLUMN");
            String columnName = ((Slice)argument.getValue()).toStringUtf8();
            return TableFunctionAnalysis.builder().handle((ConnectorTableFunctionHandle)new SimpleTableFunctionHandle(this.getSchema(), TABLE_NAME, columnName)).returnedType(new Descriptor((List)ImmutableList.of((Object)new Descriptor.Field(columnName, Optional.of(BooleanType.BOOLEAN))))).build();
        }

        public static class SimpleTableFunctionHandle
        implements ConnectorTableFunctionHandle {
            private final MockConnectorTableHandle tableHandle;

            public SimpleTableFunctionHandle(String schema, String table, String column) {
                this.tableHandle = new MockConnectorTableHandle(new SchemaTableName(schema, table), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.of((Object)new MockConnectorColumnHandle(column, (Type)BooleanType.BOOLEAN))));
            }

            public MockConnectorTableHandle getTableHandle() {
                return this.tableHandle;
            }
        }
    }
}

